/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ExtensionHook;
import javax.ide.util.MetaClass;
import oracle.ide.ExtensionRegistry;
import oracle.ide.model.HeadlessAwareMetaClassWrapper;
import oracle.ideimpl.extension.SingletonProviderHook;

public class SingletonProvider {
    private static final Logger LOG = Logger.getLogger(SingletonProvider.class.getName());
    private static final Map<String, HeadlessAwareMetaClassWrapper> METACLASS_CACHE = new ConcurrentHashMap<String, HeadlessAwareMetaClassWrapper>();
    private static final Map<String, Object> INSTANCE_CACHE = new ConcurrentHashMap<String, Object>();

    private SingletonProvider() {
    }

    public static <T> T find(Class<T> target) {
        return SingletonProvider.find(target, true);
    }

    public static <T> T findIfAvailable(Class<T> target) {
        return SingletonProvider.find(target, false);
    }

    private static <T> T find(Class<T> target, boolean create) {
        if (target == null) {
            return null;
        }
        Object instance = INSTANCE_CACHE.get(target.getName());
        if (instance != null) {
            return target.cast(instance);
        }
        if (!create) {
            return null;
        }
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        HeadlessAwareMetaClassWrapper metaClassWrapper = METACLASS_CACHE.get(target.getName());
        if (metaClassWrapper == null) {
            metaClassWrapper = SingletonProvider.findMetaClass(target, er.getHook(SingletonProviderHook.HOOK_ELEMENT));
        }
        if (metaClassWrapper != null) {
            try {
                MetaClass metaClass = metaClassWrapper.getMetaClass();
                if (metaClass != null) {
                    instance = metaClass.newInstance();
                    INSTANCE_CACHE.put(target.getName(), instance);
                    return target.cast(instance);
                }
            }
            catch (InstantiationException e) {
                LOG.log(Level.WARNING, "Can't locate a suitable singleton implementation for " + target.getName(), e);
            }
            catch (IllegalAccessException e) {
                LOG.log(Level.WARNING, "Can't locate a suitable singleton implementation for " + target.getName(), e);
            }
            catch (ClassNotFoundException e) {
                LOG.log(Level.WARNING, "Can't locate a suitable singleton implementation for " + target.getName(), e);
            }
        }
        return null;
    }

    private static <T> HeadlessAwareMetaClassWrapper findMetaClass(Class<T> target, ExtensionHook hook) {
        if (hook == null) {
            return null;
        }
        Map<String, HeadlessAwareMetaClassWrapper> metaClasses = ((SingletonProviderHook)hook).getMetaClasses();
        HeadlessAwareMetaClassWrapper mc = metaClasses.get(target.getName());
        if (mc != null) {
            METACLASS_CACHE.put(target.getName(), mc);
            return mc;
        }
        return null;
    }
}

