/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.model.ContentType;
import oracle.ide.model.Recognizer;
import oracle.javatools.data.HashStructure;

class ExtensionToContentRecognizerHookHelper {
    static Map<File, ContentType> findExtensionToContentTypes(HashStructure hs) {
        return Collections.unmodifiableMap(ExtensionToContentRecognizerHookHelper.buildExtensionToContentTypes(hs));
    }

    private static Map<File, ContentType> buildExtensionToContentTypes(HashStructure hs) {
        HashMap<File, ContentType> mappings = new HashMap<File, ContentType>();
        List mappingList = hs.getAsList("extension-to-content-type");
        if (mappingList == null) {
            return mappings;
        }
        for (Object o : mappingList) {
            if (!(o instanceof HashStructure)) continue;
            HashStructure childHs = (HashStructure)o;
            ExtensionToContentRecognizerHookHelper.addExtensionToContentTypes(childHs, mappings);
        }
        return mappings;
    }

    ExtensionToContentRecognizerHookHelper() {
    }

    private static void addExtensionToContentTypes(HashStructure hs, Map<File, ContentType> mappings) {
        List mappingList = hs.getAsList("mapping");
        if (mappingList == null) {
            return;
        }
        for (Object o : mappingList) {
            if (!(o instanceof HashStructure)) continue;
            HashStructure childHs = (HashStructure)o;
            String extension = childHs.getString("extension");
            String contentText = childHs.getString("content");
            if (extension == null || extension.length() == 0) continue;
            File fileExtension = Recognizer.sanitizeExtension(extension);
            ContentType contentType = null;
            contentType = "text".equalsIgnoreCase(contentText) ? ContentType.TEXT : ContentType.BINARY;
            mappings.put(fileExtension, contentType);
        }
    }
}

