/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import oracle.ide.model.Attributes;

public abstract class DefaultAttributes
implements Attributes {
    public static final Attributes EMPTY_ATTRIBUTES = new Attributes(){

        @Override
        public boolean isSet(int attr) {
            return false;
        }

        @Override
        public void set(int attr) {
        }

        @Override
        public void unset(int attr) {
        }

        @Override
        public void clear() {
        }

        @Override
        public Attributes duplicate() {
            return this;
        }
    };
    public static final int NONE = DefaultAttributes.noneAttr();
    private int _attributes;

    public DefaultAttributes() {
    }

    public DefaultAttributes(int attribute) {
        this.set(attribute);
    }

    public DefaultAttributes(DefaultAttributes attributes) {
        this._attributes = attributes._attributes;
    }

    @Override
    public boolean isSet(int attr) {
        return (this._attributes & attr) == attr;
    }

    @Override
    public void set(int attr) {
        this._attributes |= attr;
    }

    @Override
    public void unset(int attr) {
        this._attributes &= ~attr;
    }

    @Override
    public void clear() {
        this._attributes = DefaultAttributes.noneAttr();
    }

    protected static final int noneAttr() {
        return 0;
    }

    protected static final int minAttr() {
        return 1;
    }

    protected static final int maxAttr() {
        return Integer.MIN_VALUE;
    }

    protected static final int incAttr(int curAttr) {
        return curAttr << 1;
    }

    protected static final int decAttr(int curAttr) {
        return curAttr >>> 1;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((DefaultAttributes)o);
    }

    protected final boolean equalsImpl(DefaultAttributes other) {
        return this._attributes == other._attributes;
    }
}

