/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.log;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public final class QueuedLoggingHandler
extends Handler {
    private final BlockingQueue<LogRecord> queue = new LinkedBlockingQueue<LogRecord>();

    public QueuedLoggingHandler() {
        this.setFormatter(new SimpleFormatter());
        try {
            String name = LogManager.getLogManager().getProperty(this.getClass().getCanonicalName() + ".level");
            if (name != null) {
                Level level = Level.parse(name);
                this.setLevel(level);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public LogRecord take() throws InterruptedException {
        return this.queue.take();
    }

    public LogRecord poll() {
        return (LogRecord)this.queue.poll();
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        this.queue.offer(record);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        return record != null && super.isLoggable(record);
    }
}

