/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.XMLKeystrokeContextDef;
import oracle.ide.net.URLFileSystem;

public final class XMLKeystrokeContextDefs
implements FilenameFilter {
    private static final String KDEF_EXTENSION = ".kdf";
    private final ArrayList _acceleratorFiles = new ArrayList();
    private ArrayList _listAllPresets;
    private static XMLKeystrokeContextDefs INSTANCE;

    private XMLKeystrokeContextDefs() {
    }

    public static synchronized XMLKeystrokeContextDefs getInstance() {
        if (INSTANCE == null) {
            String sSystem;
            INSTANCE = new XMLKeystrokeContextDefs();
            ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
            URL extensionURL = er.getSystemDirectory(Ide.getProductID());
            if (extensionURL != null) {
                INSTANCE.addDirectory(URLFileSystem.getPlatformPathName((URL)extensionURL));
            }
            if ((sSystem = Ide.getSystemDirectory()) != null) {
                INSTANCE.addDirectory(sSystem);
            }
        }
        return INSTANCE;
    }

    private synchronized void addFile(String filename) {
        this._acceleratorFiles.add(new Entry(filename));
        this._listAllPresets = null;
    }

    public void addAcceleratorFile(ClassLoader classLoader, String acceleratorFile) {
        Entry entry = new Entry(classLoader, acceleratorFile);
        this._acceleratorFiles.add(entry);
    }

    @Override
    public final boolean accept(File dir, String name) {
        return name.toLowerCase().endsWith(KDEF_EXTENSION);
    }

    private void addDirectory(String sDirectoryName) {
        File directory = new File(sDirectoryName);
        if (directory.exists()) {
            File[] files = directory.listFiles(this);
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                this.addFile(f.getPath());
            }
        }
    }

    public final synchronized void unload() {
        for (int i = 0; i < this._acceleratorFiles.size(); ++i) {
            Entry entry = (Entry)this._acceleratorFiles.get(i);
            entry.unload();
        }
        this._listAllPresets = null;
    }

    private XMLKeystrokeContextDef[] getAllContextDefs() {
        ArrayList<XMLKeystrokeContextDef> ret = new ArrayList<XMLKeystrokeContextDef>(this._acceleratorFiles.size());
        for (int i = 0; i < this._acceleratorFiles.size(); ++i) {
            Entry entry = (Entry)this._acceleratorFiles.get(i);
            XMLKeystrokeContextDef xmlKeystrokeContextDef = entry.getXmlKeystrokeContextDef();
            if (xmlKeystrokeContextDef == null) {
                this._acceleratorFiles.remove(i);
                --i;
                continue;
            }
            ret.add(xmlKeystrokeContextDef);
        }
        return ret.toArray(new XMLKeystrokeContextDef[ret.size()]);
    }

    public final synchronized List getAllPresets() {
        if (this._listAllPresets == null) {
            this._listAllPresets = new ArrayList(5);
            XMLKeystrokeContextDef[] allContextDefs = this.getAllContextDefs();
            for (int i = 0; i < allContextDefs.length; ++i) {
                XMLKeystrokeContextDef xmlKeystrokeContextDef = allContextDefs[i];
                xmlKeystrokeContextDef.addAllPresets(this._listAllPresets);
            }
        }
        return this._listAllPresets;
    }

    public final Set getAllActions(String sContext, boolean bGlobal) {
        HashSet set = new HashSet();
        XMLKeystrokeContextDef[] allContextDefs = this.getAllContextDefs();
        for (int i = 0; i < allContextDefs.length; ++i) {
            XMLKeystrokeContextDef xmlKeystrokeContextDef = allContextDefs[i];
            xmlKeystrokeContextDef.addAllActions(set, sContext, bGlobal);
        }
        return set;
    }

    public final KeyStrokeMap getPresetKeyStrokeMap(String sContext, Object preset, boolean bGlobal) {
        KeyStrokeMap ksm = new KeyStrokeMap();
        if (preset != null) {
            String sPresetName = preset.toString();
            XMLKeystrokeContextDef[] allContextDefs = this.getAllContextDefs();
            for (int i = 0; i < allContextDefs.length; ++i) {
                XMLKeystrokeContextDef xmlKeystrokeContextDef = allContextDefs[i];
                xmlKeystrokeContextDef.addPresetKeyStrokeMap(ksm, sContext, sPresetName, bGlobal);
            }
        }
        return ksm;
    }

    private static class Entry {
        private String _filename;
        private ClassLoader _classLoader;
        private XMLKeystrokeContextDef _xmlKeystrokeContextDef;

        Entry(String filename) {
            this(null, filename);
        }

        Entry(ClassLoader classLoader, String filename) {
            this._classLoader = classLoader;
            this._filename = filename;
        }

        XMLKeystrokeContextDef getXmlKeystrokeContextDef() {
            if (this._xmlKeystrokeContextDef == null) {
                this._xmlKeystrokeContextDef = this._classLoader == null ? XMLKeystrokeContextDef.load(this._filename) : XMLKeystrokeContextDef.load(this._classLoader, this._filename);
            }
            return this._xmlKeystrokeContextDef;
        }

        void unload() {
            this._xmlKeystrokeContextDef = null;
        }
    }
}

