/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.DefaultRowSorter;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.help.HelpSystem;
import oracle.ide.keyboard.ActionElement;
import oracle.ide.keyboard.ActionElementRenderer;
import oracle.ide.keyboard.KeyStrokeArb;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokePanel;
import oracle.ide.keyboard.KeyStrokeTableModel;
import oracle.ide.keyboard.KeyStrokeTableRowFilter;
import oracle.ide.util.GhostPaletteUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ghost.GhostPalette;
import oracle.javatools.ui.ghost.UIConstants;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.table.GenericTable;

final class QuickActionController
implements Controller {
    private static final int QUICK_ACTION_CMD_ID = Ide.findOrCreateCmdID("Ide.QUICK_ACTION_CMD_ID");
    private static String QUICK_OUTLINE_KEY = "QUICK_OUTLINE";
    private GhostPalette palette;
    private SearchField searchField;
    private GenericTable resultsTable;
    private SearchListener searchListener = new SearchListener(){

        public void searchPerformed(SearchEvent se) {
            QuickActionController.this.filter(QuickActionController.this.searchField.getText());
        }

        public void searchCategoryChanged(SearchEvent se) {
        }
    };
    private MouseListener mouseL = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getClickCount() == 2) {
                QuickActionController.this.chooseSelection();
            }
        }
    };

    QuickActionController() {
    }

    @Override
    public boolean handleEvent(IdeAction action, Context context) {
        if (action.getCommandId() == QUICK_ACTION_CMD_ID) {
            if (!this.isShowing()) {
                this.show();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean update(IdeAction action, Context context) {
        if (action.getCommandId() == QUICK_ACTION_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        return false;
    }

    private void hidden() {
        if (this.searchField != null) {
            this.searchField.removeSearchListener(this.searchListener);
        }
        if (this.resultsTable != null) {
            this.resultsTable.removeMouseListener(this.mouseL);
        }
        this.palette = null;
        this.searchField = null;
        this.resultsTable = null;
    }

    private void show() {
        JComponent owner = (JComponent)Ide.getMainWindow().getContentPane();
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        this.palette = new GhostPalette(focusOwner instanceof JComponent ? (JComponent)focusOwner : owner){

            public void removeNotify() {
                super.removeNotify();
                QuickActionController.this.hidden();
            }
        };
        this.palette.setTitle(KeyStrokeArb.getString(38));
        this.palette.setResizable(false);
        JPanel content = new JPanel(new BorderLayout(4, 4));
        content.add(this.createResultList(), "Center");
        content.add(this.createSearchField(), "North");
        this.palette.add((Component)content);
        HelpSystem helpSystem = HelpSystem.getHelpSystem();
        if (helpSystem != null) {
            helpSystem.registerTopic((JComponent)this.palette, "f1_idequickaction_html");
        }
        if (!this.palette.isShowing()) {
            GhostPaletteUtil.show(this.palette, QUICK_OUTLINE_KEY, true, 350, 420);
        }
        this.resultsTable.setVisibleRows(Math.min(16, this.resultsTable.getRowCount()));
        this.palette.pack();
    }

    private boolean isShowing() {
        return this.palette != null && this.palette.isShowing();
    }

    private Component createSearchField() {
        this.searchField = new SearchField(SearchField.Style.FILTER);
        this.searchField.getTextField().setPrompt(KeyStrokeArb.getString(39));
        this.searchField.setKeyEventTargetComponent((Component)this.resultsTable);
        this.searchField.addSearchListener(this.searchListener);
        String ACTION = "Action";
        this.searchField.getTextField().getInputMap(1).put(KeyStroke.getKeyStroke(10, 0, false), "Action");
        this.searchField.getTextField().getActionMap().put("Action", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickActionController.this.chooseSelection();
            }
        });
        return this.searchField;
    }

    private Component createResultList() {
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.loadAcceleratorDefinitionFiles();
        IdeSettings ideSettings = Ide.getSettings();
        KeyStrokeOptions kso = ideSettings.getKeyStrokeOptions();
        KeyStrokeTableModel tableModel = new KeyStrokeTableModel();
        this.resultsTable = new GenericTable((TableModel)tableModel);
        KeyStrokePanel.fillActions(this.resultsTable, tableModel, kso, false);
        this.resultsTable.putClientProperty((Object)UIConstants.VETO_HIERARCHY_CONVERSION, (Object)true);
        this.resultsTable.setRolloverHighlightingEnabled(false);
        this.resultsTable.autoSizeColumnsToFit();
        this.resultsTable.setRowHeight(20);
        this.resultsTable.setShowGrid(true);
        this.resultsTable.setDragEnabled(false);
        this.resultsTable.setShowHorizontalLines(true);
        this.resultsTable.setColumnSelectionAllowed(false);
        this.resultsTable.setSelectionMode(1);
        this.resultsTable.setColumnSelectorAvailable(false);
        this.resultsTable.setVisibleRows(Math.min(16, this.resultsTable.getRowCount()));
        TableRowSorter<KeyStrokeTableModel> rowSorter = new TableRowSorter<KeyStrokeTableModel>(tableModel);
        rowSorter.setStringConverter(new TableStringConverter(){

            @Override
            public String toString(TableModel model, int row, int column) {
                Object val = model.getValueAt(row, column);
                return val == null ? "" : val.toString().toLowerCase();
            }
        });
        ArrayList keys = new ArrayList();
        rowSorter.setSortKeys(keys);
        rowSorter.setSortsOnUpdates(true);
        this.resultsTable.setRowSorter(rowSorter);
        this.resultsTable.autoSizeColumnsToFit();
        rowSorter.toggleSortOrder(1);
        TableColumnModel colModel = this.resultsTable.getColumnModel();
        TableColumn idColumn = colModel.getColumn(3);
        TableColumn nameColumn = colModel.getColumn(4);
        TableColumn categoryColumn = colModel.getColumn(0);
        colModel.removeColumn(idColumn);
        colModel.removeColumn(nameColumn);
        colModel.removeColumn(categoryColumn);
        this.resultsTable.getColumnModel().getColumn(0).setCellRenderer(new ActionElementRenderer());
        this.resultsTable.setShowGrid(false);
        this.resultsTable.addMouseListener(this.mouseL);
        this.resultsTable.setTableHeader(null);
        JScrollPane sp = new JScrollPane((Component)this.resultsTable, 20, 31);
        return sp;
    }

    private void filter(String text) {
        if (this.resultsTable != null) {
            KeyStrokeTableRowFilter filter = new KeyStrokeTableRowFilter(false, text.toLowerCase());
            filter.setFilterColumns(new int[]{1});
            ((DefaultRowSorter)this.resultsTable.getRowSorter()).setRowFilter(filter);
            this.resultsTable.setVisibleRows(Math.min(16, this.resultsTable.getRowCount()));
            if (this.resultsTable.getSelectedRow() <= 0 && this.resultsTable.getRowCount() > 0) {
                this.resultsTable.getSelectionModel().setSelectionInterval(0, 0);
            }
            this.palette.pack();
        }
    }

    private void chooseSelection() {
        if (this.resultsTable != null && this.resultsTable.getSelectedRow() > -1) {
            KeyStrokeTableModel tableModel = (KeyStrokeTableModel)this.resultsTable.getModel();
            int i = this.resultsTable.getSelectedRow();
            i = this.resultsTable.getRowSorter().convertRowIndexToModel(i);
            ActionElement elem = tableModel.getActionElement(i);
            IdeAction action = elem._act;
            JRootPane parent = this.palette.getRootPane();
            boolean showError = false;
            try {
                this.palette.hidePanel();
                action.updateAction();
                if (action.isEnabled()) {
                    action.performAction();
                } else {
                    showError = true;
                }
            }
            catch (Exception e) {
                showError = true;
            }
            if (showError) {
                MessageDialog.optionalInformation((String)QUICK_OUTLINE_KEY, (Component)parent, (Object)KeyStrokeArb.getString(43), (String)KeyStrokeArb.getString(44), null);
            }
        }
    }
}

