/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.InputMapUIResource;
import oracle.ide.Ide;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;

public class IdeInputMapUIResource
extends InputMapUIResource {
    private static HashSet _ignore;
    private static boolean _mustIgnore;
    private static int _lastChangeID;
    private InputMap _realInputMap;
    private int _lastKnownChangeID;
    private boolean _hasKeysToIgnore;

    public static void replaceInputMapUIResources() {
        UIDefaults lookAndFeelDefaults = UIManager.getLookAndFeelDefaults();
        Enumeration en = lookAndFeelDefaults.keys();
        while (en.hasMoreElements()) {
            InputMap inputMap;
            Object key = en.nextElement();
            if (!(key instanceof String) || !((String)key).toLowerCase().endsWith(".focusinputmap") || (inputMap = (InputMap)lookAndFeelDefaults.get(key)) instanceof IdeInputMapUIResource) continue;
            IdeInputMapUIResource ideInputMapUIResource = new IdeInputMapUIResource(inputMap);
            lookAndFeelDefaults.put(key, ideInputMapUIResource);
        }
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                KeyStrokeOptions keyStrokeOptions = (KeyStrokeOptions)((Object)e.getSource());
                IdeInputMapUIResource.clearIgnoreList();
                KeyStrokeMap globalKeyStrokeMap = keyStrokeOptions.getGlobalKeyMap();
                IdeInputMapUIResource.fillIgnoreList(globalKeyStrokeMap);
                HashMap localKeyMaps = keyStrokeOptions.getLocalKeyMaps();
                if (localKeyMaps != null) {
                    for (KeyStrokeMap localKeyStrokeMap : localKeyMaps.values()) {
                        IdeInputMapUIResource.fillIgnoreList(localKeyStrokeMap);
                    }
                }
            }
        };
        Ide.getSettings().getKeyStrokeOptions().addChangeListener(changeListener);
    }

    private static void fillIgnoreList(KeyStrokeMap keyStrokeMap) {
        Collection<KeyStroke> multikeyKeystrokes = keyStrokeMap.getMultikeyKeystrokes();
        for (KeyStroke keyStroke : multikeyKeystrokes) {
            IdeInputMapUIResource.ignore(keyStroke);
        }
    }

    private static void ignore(KeyStroke keyStroke) {
        if (_ignore == null) {
            _ignore = new HashSet();
        }
        _ignore.add(keyStroke);
        IdeInputMapUIResource.whenIgnoreListChanges();
    }

    public static void clearIgnoreList() {
        _ignore = null;
        ++_lastChangeID;
    }

    private static void whenIgnoreListChanges() {
        ++_lastChangeID;
    }

    private IdeInputMapUIResource(InputMap inputMap) {
        this._realInputMap = inputMap;
    }

    public static boolean isMustIgnore() {
        return _mustIgnore;
    }

    public static void setMustIgnore(boolean mustIgnore) {
        _mustIgnore = mustIgnore;
    }

    private boolean hasChanged() {
        return _lastChangeID != this._lastKnownChangeID;
    }

    private void setChangedFlag(boolean changed) {
        this._lastKnownChangeID = changed ? _lastChangeID - 1 : _lastChangeID;
    }

    private boolean hasKeysToIgnore() {
        if (this.hasChanged()) {
            this._hasKeysToIgnore = false;
            if (_ignore != null) {
                KeyStroke[] keyStrokes = this._realInputMap.allKeys();
                for (int i = 0; i < keyStrokes.length; ++i) {
                    KeyStroke keyStroke = keyStrokes[i];
                    if (!_ignore.contains(keyStroke)) continue;
                    this._hasKeysToIgnore = true;
                    break;
                }
            }
            this.setChangedFlag(false);
        }
        return this._hasKeysToIgnore;
    }

    private KeyStroke[] filter(KeyStroke[] keyStrokes) {
        if (this.hasKeysToIgnore()) {
            ArrayList<KeyStroke> newList = new ArrayList<KeyStroke>(keyStrokes.length);
            for (int i = 0; i < keyStrokes.length; ++i) {
                KeyStroke keyStroke = keyStrokes[i];
                if (_ignore.contains(keyStroke)) continue;
                newList.add(keyStroke);
            }
            keyStrokes = new KeyStroke[newList.size()];
            newList.toArray(keyStrokes);
        }
        return keyStrokes;
    }

    @Override
    public Object get(KeyStroke keyStroke) {
        if (IdeInputMapUIResource.isMustIgnore() && _ignore != null && _ignore.contains(keyStroke)) {
            return null;
        }
        return this._realInputMap.get(keyStroke);
    }

    @Override
    public void setParent(InputMap map) {
        this._realInputMap.setParent(map);
        this.setChangedFlag(true);
    }

    @Override
    public InputMap getParent() {
        return this._realInputMap.getParent();
    }

    @Override
    public void put(KeyStroke keyStroke, Object actionMapKey) {
        this._realInputMap.put(keyStroke, actionMapKey);
        this.setChangedFlag(true);
    }

    @Override
    public void remove(KeyStroke key) {
        this._realInputMap.remove(key);
        this.setChangedFlag(true);
    }

    @Override
    public void clear() {
        this._realInputMap.clear();
        this.setChangedFlag(true);
    }

    @Override
    public KeyStroke[] keys() {
        KeyStroke[] keyStrokes = this._realInputMap.keys();
        if (IdeInputMapUIResource.isMustIgnore()) {
            keyStrokes = this.filter(keyStrokes);
        }
        return keyStrokes;
    }

    @Override
    public int size() {
        int ret;
        if (IdeInputMapUIResource.isMustIgnore() && this.hasKeysToIgnore()) {
            KeyStroke[] keyStrokes = this._realInputMap.keys();
            ret = 0;
            for (int i = 0; i < keyStrokes.length; ++i) {
                KeyStroke keyStroke = keyStrokes[i];
                if (_ignore.contains(keyStroke)) continue;
                ++ret;
            }
        } else {
            ret = this._realInputMap.size();
        }
        return ret;
    }

    @Override
    public KeyStroke[] allKeys() {
        KeyStroke[] keyStrokes = this._realInputMap.allKeys();
        if (IdeInputMapUIResource.isMustIgnore()) {
            this.filter(keyStrokes);
        }
        return keyStrokes;
    }

    static {
        _lastChangeID = 1;
    }
}

