/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.history;

import java.net.URL;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.history.Historian;
import oracle.ide.history.LocalState;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.SingletonProvider;
import oracle.javatools.jndi.Names;

public abstract class HistoryManager {
    private static final Lock _managerLock = new ReentrantLock();
    private static final String HISTORY_MGR_NAME = "ide/history-manager";

    public static HistoryManager getHistoryManager() {
        _managerLock.lock();
        try {
            HistoryManager historyMgr = (HistoryManager)Names.lookup((javax.naming.Context)Names.newInitialContext(), (String)HISTORY_MGR_NAME);
            if (historyMgr == null && (historyMgr = SingletonProvider.find(HistoryManager.class)) != null) {
                HistoryManager.setHistoryManager(historyMgr);
            }
            HistoryManager historyManager = historyMgr;
            return historyManager;
        }
        finally {
            _managerLock.unlock();
        }
    }

    public static void setHistoryManager(HistoryManager historyManager) {
        _managerLock.lock();
        try {
            Names.bind((javax.naming.Context)Names.newInitialContext(), (String)HISTORY_MGR_NAME, (Object)historyManager);
        }
        finally {
            _managerLock.unlock();
        }
    }

    public abstract boolean hasLocalHistory(URL var1);

    public abstract LocalState[] getLocalHistory(URL var1);

    public abstract LocalState[] getLocalHistory(Object var1);

    public abstract LocalState getLastState(Object var1);

    public abstract Object[] getDeletions(URL var1);

    public abstract void persistInitialState(URL[] var1) throws Exception;

    public abstract void persist(URL[] var1, String var2) throws Exception;

    public abstract void restore(LocalState[] var1, Context var2) throws Exception;

    public abstract void clear(URL[] var1);

    @Deprecated
    public abstract void registerHistorian(Class var1, Class var2);

    public abstract void registerHistorian(MetaClass<? extends Historian> var1, MetaClass<? extends Node> var2);

    public abstract boolean isHistoried(Element var1);

    @Deprecated
    public final Class getRegisteredHistorian(Class objCls) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }
}

