/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.help;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.naming.Context;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.AboutBox;
import oracle.ide.help.AboutBoxModel;
import oracle.ide.help.AboutBoxPage;
import oracle.ide.resource.IdeArb;
import oracle.javatools.jndi.Names;

public class AboutBoxFactory {
    private static final String ABOUT_BOX_FACTORY_NAME = "ide/about-box-factory";
    private static final Dimension DEFAULT_SIZE = new Dimension(600, 400);
    private final List _pageClasses = new ArrayList();
    private AboutBoxModel _model = null;

    public static final AboutBoxFactory getAboutBoxFactory() {
        return (AboutBoxFactory)Names.lookup((Context)Names.newInitialContext(), (String)ABOUT_BOX_FACTORY_NAME);
    }

    public static final void setAboutBoxFactory(AboutBoxFactory factory) {
        Names.bind((Context)Names.newInitialContext(), (String)ABOUT_BOX_FACTORY_NAME, (Object)factory);
    }

    public void setModel(AboutBoxModel model) {
        this._model = model;
    }

    public final void addPage(Class pageClass) {
        if (pageClass == null) {
            throw new NullPointerException("Null page class.");
        }
        this._pageClasses.add(pageClass);
    }

    public final void removePage(Class pageClass) {
        if (pageClass != null) {
            this._pageClasses.remove(pageClass);
        }
    }

    public void showAboutBox() {
        if (this._model == null) {
            throw new IllegalStateException("No about box model.");
        }
        AboutBox aboutBox = new AboutBox(this._model);
        for (Class c : this._pageClasses) {
            try {
                AboutBoxPage page = (AboutBoxPage)c.newInstance();
                aboutBox.addPage(page);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.runDialog(aboutBox);
    }

    private void runDialog(AboutBox aboutBox) {
        JComponent initialFocus = aboutBox.getInitialFocusedComponent();
        String programName = this._model.getProductName();
        String dialogTitle = IdeArb.format(428, programName);
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog(aboutBox, initialFocus, dialogTitle, 1);
        dlg.setPreferredSize(DEFAULT_SIZE);
        dlg.runDialog();
        dlg.dispose();
    }
}

