/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.extension;

import javax.ide.util.MetaResource;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.SharedExtensionUtils;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;

public class LazyResourceAdapter
extends HashStructureAdapter {
    public LazyResourceAdapter(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static LazyResourceAdapter getInstance(HashStructure hash) {
        return new LazyResourceAdapter(hash);
    }

    public MetaResource getMetaResource(String keyName) {
        if (keyName == null) {
            throw new NullPointerException("keyName is null.");
        }
        String fqName = this._hash.getString(keyName);
        if (fqName == null || (fqName = fqName.trim()).length() == 0) {
            return null;
        }
        String extensionId = SharedExtensionUtils.findExtensionClassLoader(keyName, this._hash);
        if (extensionId == null) {
            return null;
        }
        ClassLoader loader = ExtensionRegistry.getExtensionRegistry().getClassLoader(extensionId);
        if (loader == null) {
            throw new IllegalStateException("Classloader not found for extension " + extensionId);
        }
        return new MetaResource(loader, fqName);
    }
}

