/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.explorer;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ide.util.MetaClass;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import oracle.ide.Ide;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.explorer.IconOverlayConsumer;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.javaxide.Util;
import oracle.ide.model.Element;
import oracle.javatools.util.NamedTimer;

public final class IconOverlayCoordinator {
    private static final int DEFAULT_BATCH_SIZE = 10;
    private static final long THREAD_DELAY_TIME = 500L;
    private static final ExecutorService _executor = new ThreadPoolExecutor(0, 1, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
        private final ThreadFactory _delegate = Executors.defaultThreadFactory();

        @Override
        public final Thread newThread(Runnable r) {
            Thread t = this._delegate.newThread(r);
            t.setName("IconOverlayTracker Daemon");
            return t;
        }
    });
    private final Map<IconOverlayConsumer, NodeWatcher> _nodeWatchers = new HashMap<IconOverlayConsumer, NodeWatcher>();
    private final Map<IconOverlayConsumer, LinkedList> _pendingNodes = new HashMap<IconOverlayConsumer, LinkedList>();
    private final MetaClass<? extends IconOverlayTracker> _trackerClass;
    private IconOverlayTracker _tracker;
    private final ChangeListener _viewChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            IconOverlayCoordinator.this.repaintConsumerOverlays((IconOverlayConsumer)e.getSource(), 500L);
        }
    };
    private TimerTask _updateTask;
    private final Object _timerLock = new Object();
    private Timer _timer;
    private boolean _exited;
    private ChangeListener _consumerChangeListener;
    private final String _extensionId;
    private final String _infoTypeId;
    private final IconOverlayCache _overlayCache;
    private final int _batchSize;

    IconOverlayCoordinator(String extensionId, String infoTypeId, int batchSize, MetaClass<? extends IconOverlayTracker> trackerClass) {
        this._extensionId = extensionId;
        this._trackerClass = trackerClass;
        this._tracker = null;
        this._infoTypeId = infoTypeId;
        this._overlayCache = IconOverlayCache.getInstance();
        this._batchSize = batchSize > 0 ? batchSize : 10;
    }

    @Deprecated
    IconOverlayCoordinator(String infoTypeId, IconOverlayCache cache, int batchSize, IconOverlayTracker tracker) {
        this._extensionId = null;
        this._trackerClass = null;
        this._tracker = tracker;
        this._infoTypeId = infoTypeId;
        this._overlayCache = cache;
        this._batchSize = batchSize > 0 ? batchSize : 10;
        this.initializeTracker();
    }

    final String getExtensionID() {
        return this._extensionId;
    }

    final String getInfoTypeID() {
        return this._infoTypeId;
    }

    public final IconOverlayTracker getOverlayTracker() {
        return this._tracker;
    }

    private final void initializeTracker() {
        this._tracker.setExtensionId(this._extensionId);
        this._tracker.setOverlayCache(this._overlayCache);
        this._tracker.setInfoTypeId(this._infoTypeId);
        this._tracker.setBatchSize(this._batchSize);
        this._tracker.setCoordinator(this);
        this._tracker.configure();
    }

    final void attachToConsumers() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public final void run() {
                IconOverlayCoordinator.this.processConsumerChangeEvent();
            }
        });
        this._consumerChangeListener = new ChangeListener(){

            @Override
            public final void stateChanged(ChangeEvent e) {
                IconOverlayCoordinator.this.processConsumerChangeEvent();
            }
        };
        this._overlayCache.addConsumerChangeListener(this._consumerChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processConsumerChangeEvent() {
        IconOverlayCoordinator iconOverlayCoordinator = this;
        synchronized (iconOverlayCoordinator) {
            HashSet registrations = new HashSet(this._overlayCache.getOverlayConsumers());
            HashSet<IconOverlayConsumer> deregistrations = new HashSet<IconOverlayConsumer>();
            Map<IconOverlayConsumer, NodeWatcher> map = this._nodeWatchers;
            synchronized (map) {
                registrations.removeAll(this._nodeWatchers.keySet());
                deregistrations.addAll(this._nodeWatchers.keySet());
            }
            deregistrations.removeAll(this._overlayCache.getOverlayConsumers());
            Iterator itr = registrations.iterator();
            while (itr.hasNext()) {
                this.registerOverlayConsumer((IconOverlayConsumer)itr.next());
            }
            itr = deregistrations.iterator();
            while (itr.hasNext()) {
                this.deregisterOverlayConsumer((IconOverlayConsumer)itr.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerOverlayConsumer(IconOverlayConsumer consumer) {
        if (this._tracker != null) {
            this._tracker.start();
        }
        Map<IconOverlayConsumer, Object> map = this._nodeWatchers;
        synchronized (map) {
            if (this._nodeWatchers.containsKey(consumer)) {
                return;
            }
            NodeWatcher watcher = new NodeWatcher(consumer);
            watcher.addVisibleNodeListener(this._viewChangeListener);
            this._nodeWatchers.put(consumer, watcher);
        }
        map = this._pendingNodes;
        synchronized (map) {
            this._pendingNodes.put(consumer, null);
        }
        this.repaintConsumerOverlays(consumer, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterOverlayConsumer(IconOverlayConsumer consumer) {
        if (this._tracker != null) {
            this._tracker.start();
        }
        Map<IconOverlayConsumer, Object> map = this._nodeWatchers;
        synchronized (map) {
            if (!this._nodeWatchers.containsKey(consumer)) {
                return;
            }
            NodeWatcher watcher = this._nodeWatchers.get(consumer);
            watcher.removeVisibleNodeListener(this._viewChangeListener);
            this._nodeWatchers.remove(consumer);
            watcher.performCleanup();
        }
        map = this._pendingNodes;
        synchronized (map) {
            this._pendingNodes.remove(consumer);
        }
        this.repaintConsumerOverlays(consumer, 0L);
    }

    public final void dispose() {
        if (this._tracker != null) {
            this._tracker.stop();
        } else {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void stop() {
        this._dispose();
        Object object = this._timerLock;
        synchronized (object) {
            if (this._exited) {
                return;
            }
            this._exited = true;
        }
        TimerTask task = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    IconOverlayCoordinator.this.cleanUpNodeWatchers();
                    Object object = IconOverlayCoordinator.this._timerLock;
                    synchronized (object) {
                        IconOverlayCoordinator.this.getTimer().cancel();
                    }
                    this.timerStopped();
                }
                catch (Exception e) {
                    FeedbackManager.reportException(e);
                }
            }

            private void timerStopped() {
                if (IconOverlayCoordinator.this._tracker != null) {
                    IconOverlayCoordinator.this._tracker.validateOverlays();
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public final void run() {
                        IconOverlayCache cache = IconOverlayCoordinator.this.getOverlayCache();
                        if (cache == null) {
                            return;
                        }
                        cache.clearOverlays(IconOverlayCoordinator.this._infoTypeId);
                        cache.fireOverlaysChanged();
                    }
                });
            }
        };
        Object object2 = this._timerLock;
        synchronized (object2) {
            if (this._timer == null) {
                this.cleanUpNodeWatchers();
                return;
            }
            this.getTimer().schedule(task, 0L);
        }
    }

    private final IconOverlayCache getOverlayCache() {
        return this._overlayCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cleanUpNodeWatchers() {
        Map<IconOverlayConsumer, NodeWatcher> map = this._nodeWatchers;
        synchronized (map) {
            for (NodeWatcher watcher : this._nodeWatchers.values()) {
                watcher.removeVisibleNodeListener(this._viewChangeListener);
                watcher.performCleanup();
            }
        }
    }

    final void _dispose() {
        if (this._consumerChangeListener != null) {
            this._overlayCache.removeConsumerChangeListener(this._consumerChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void repaintConsumerOverlays(Collection<IconOverlayConsumer> consumers, long delay) {
        Map<IconOverlayConsumer, LinkedList> map = this._pendingNodes;
        synchronized (map) {
            Iterator<IconOverlayConsumer> itr = consumers.iterator();
            while (itr.hasNext()) {
                this.repaintConsumerOverlaysImpl(itr.next());
            }
        }
        this.scheduleUpdateTask(delay, consumers);
    }

    final Map<IconOverlayConsumer, NodeWatcher> getNodeWatchers() {
        return this._nodeWatchers;
    }

    final Map<IconOverlayConsumer, LinkedList> getPendingNodes() {
        return this._pendingNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repaintConsumerOverlays(IconOverlayConsumer consumer, long delay) {
        Map<IconOverlayConsumer, LinkedList> map = this._pendingNodes;
        synchronized (map) {
            this.repaintConsumerOverlaysImpl(consumer);
        }
        this.scheduleUpdateTask(delay, Collections.singleton(consumer));
    }

    private void repaintConsumerOverlaysImpl(IconOverlayConsumer consumer) {
        if (!this._pendingNodes.containsKey(consumer)) {
            return;
        }
        this._pendingNodes.put(consumer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleUpdateTask(final long delay, final Collection<IconOverlayConsumer> consumers) {
        if (Ide.isQuitting()) {
            return;
        }
        Object object = this._timerLock;
        synchronized (object) {
            if (this._timer != null) {
                this._scheduleUpdateTask(delay, consumers);
                return;
            }
        }
        object = _executor;
        synchronized (object) {
            _executor.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public final void run() {
                    Object object = IconOverlayCoordinator.this._timerLock;
                    synchronized (object) {
                        IconOverlayCoordinator.this._scheduleUpdateTask(delay, consumers);
                    }
                }
            });
        }
    }

    private final void _scheduleUpdateTask(long delay, Collection<IconOverlayConsumer> consumers) {
        if (this._exited) {
            return;
        }
        if (this._timer == null && !this.isVisibleNodeControlled(consumers)) {
            return;
        }
        if (this._updateTask != null) {
            this._updateTask.cancel();
        }
        this._updateTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    IconOverlayCoordinator.this.getOrCreateTracker().processPendingNodes();
                }
                catch (Exception e) {
                    FeedbackManager.reportException(e);
                }
            }
        };
        try {
            this.getTimer().schedule(this._updateTask, delay);
        }
        catch (IllegalStateException ise) {
            FeedbackManager.reportException(ise);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timer getTimer() {
        if (this._timer != null) {
            return this._timer;
        }
        Object object = this._timerLock;
        synchronized (object) {
            if (this._timer == null) {
                this._timer = new NamedTimer("IconOverlayTracker Timer: " + this.getExtensionID() + "-" + this.getInfoTypeID());
            }
        }
        return this._timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isVisibleNodeControlled(Collection<IconOverlayConsumer> consumers) {
        for (IconOverlayConsumer consumer : consumers) {
            Collection visible;
            Map<IconOverlayConsumer, NodeWatcher> map = this._nodeWatchers;
            synchronized (map) {
                NodeWatcher watcher = this._nodeWatchers.get(consumer);
                if (watcher == null) {
                    continue;
                }
                visible = watcher.getVisibleNodes();
            }
            Iterator itr = visible.iterator();
            while (itr.hasNext()) {
                Element e = consumer.getElement(itr.next());
                if (e == null || !this.getOrCreateTracker().isControlled(e)) continue;
                return true;
            }
        }
        return false;
    }

    private final IconOverlayTracker getOrCreateTracker() {
        if (this._tracker != null) {
            return this._tracker;
        }
        if (this._trackerClass == null) {
            throw new IllegalStateException();
        }
        this._tracker = Util.createInstance(this._trackerClass, IconOverlayTracker.class);
        this.initializeTracker();
        this._tracker.start();
        return this._tracker;
    }

    final class NodeWatcher {
        private final JTree _tree;
        private final Object _source;
        private final ChangeListener _scrollListener = new ScrollPaneListener();
        private final TreeModelListener _modelListener = new NodeModelListener();
        private final TreeExpansionListener _nodeListener = new NodeUserListener();
        private final ParentListener _parentListener = new ParentListener();
        private Collection _nodes = new ArrayList();
        private Collection _listeners = new ArrayList();
        private boolean _cleanup;

        private NodeWatcher(IconOverlayConsumer consumer) {
            this._tree = consumer.getJTree();
            this._source = consumer;
            this._tree.addAncestorListener(this._parentListener);
            if (this.isComponentVisible(this._tree)) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public final void run() {
                        NodeWatcher.this.addInternalListeners();
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addVisibleNodeListener(ChangeListener l) {
            Collection collection = this._listeners;
            synchronized (collection) {
                this._listeners.remove(l);
                this._listeners.add(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeVisibleNodeListener(ChangeListener l) {
            Collection collection = this._listeners;
            synchronized (collection) {
                this._listeners.remove(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final Collection getVisibleNodes() {
            Collection collection = this._nodes;
            synchronized (collection) {
                return new ArrayList(this._nodes);
            }
        }

        private void performCleanup() {
            this._cleanup = true;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public final void run() {
                    NodeWatcher.this._tree.removeAncestorListener(NodeWatcher.this._parentListener);
                    NodeWatcher.this.removeInternalListeners();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void updateVisibleNodes() {
            Object object = IconOverlayCoordinator.this._timerLock;
            synchronized (object) {
                if (IconOverlayCoordinator.this._exited) {
                    return;
                }
                this._updateVisibleNodes();
                if (IconOverlayCoordinator.this._timer != null) {
                    try {
                        IconOverlayCoordinator.this.getTimer().schedule(new TimerTask(){

                            @Override
                            public void run() {
                                try {
                                    NodeWatcher.this._updateVisibleNodes();
                                }
                                catch (Exception e) {
                                    FeedbackManager.reportException(e);
                                }
                            }
                        }, 500L);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
            }
        }

        private final void _updateVisibleNodes() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public final void run() {
                    NodeWatcher.this.setVisibleNodes(IconOverlayCache.getVisibleNodes(NodeWatcher.this._tree));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void setVisibleNodes(Collection c) {
            Collection collection = this._nodes;
            synchronized (collection) {
                boolean changed = !Arrays.equals(this._nodes.toArray(), c.toArray());
                this._nodes = c;
                if (!changed) {
                    return;
                }
            }
            ChangeEvent e = new ChangeEvent(this._source);
            ChangeListener[] l = null;
            Collection collection2 = this._listeners;
            synchronized (collection2) {
                l = this._listeners.toArray(new ChangeListener[this._listeners.size()]);
            }
            for (int i = l.length - 1; i >= 0; --i) {
                l[i].stateChanged(e);
            }
        }

        private final void addInternalListeners() {
            if (this._cleanup) {
                return;
            }
            this.removeInternalListenersImpl();
            this.addInternalListenersImpl();
            this.updateVisibleNodes();
        }

        private final void removeInternalListeners() {
            this.removeInternalListenersImpl();
            this.setVisibleNodes(new ArrayList());
        }

        private final void addInternalListenersImpl() {
            this._tree.getModel().addTreeModelListener(this._modelListener);
            this._tree.addTreeExpansionListener(this._nodeListener);
            if (!(this._tree.getParent() instanceof JViewport)) {
                return;
            }
            JViewport viewport = (JViewport)this._tree.getParent();
            viewport.addChangeListener(this._scrollListener);
        }

        private final void removeInternalListenersImpl() {
            if (this._tree.getModel() != null) {
                this._tree.getModel().removeTreeModelListener(this._modelListener);
            }
            this._tree.removeTreeExpansionListener(this._nodeListener);
            if (!(this._tree.getParent() instanceof JViewport)) {
                return;
            }
            JViewport viewport = (JViewport)this._tree.getParent();
            viewport.removeChangeListener(this._scrollListener);
        }

        private final JTree getTree() {
            return this._tree;
        }

        private final boolean isComponentVisible(Component c) {
            while (c != null) {
                if (!c.isVisible()) {
                    return false;
                }
                if (c instanceof Window) {
                    return true;
                }
                c = c.getParent();
            }
            return false;
        }

        private final class NodeUserListener
        implements TreeExpansionListener {
            private NodeUserListener() {
            }

            @Override
            public final void treeCollapsed(TreeExpansionEvent event) {
                NodeWatcher.this.updateVisibleNodes();
            }

            @Override
            public final void treeExpanded(TreeExpansionEvent event) {
                NodeWatcher.this.updateVisibleNodes();
            }
        }

        private final class NodeModelListener
        implements TreeModelListener {
            private NodeModelListener() {
            }

            @Override
            public final void treeNodesChanged(TreeModelEvent e) {
            }

            @Override
            public final void treeNodesInserted(TreeModelEvent e) {
                NodeWatcher.this.updateVisibleNodes();
            }

            @Override
            public final void treeNodesRemoved(TreeModelEvent e) {
                NodeWatcher.this.updateVisibleNodes();
            }

            @Override
            public final void treeStructureChanged(TreeModelEvent e) {
                NodeWatcher.this.updateVisibleNodes();
            }
        }

        private final class ScrollPaneListener
        implements ChangeListener {
            private Rectangle _r = null;

            private ScrollPaneListener() {
            }

            @Override
            public final void stateChanged(ChangeEvent e) {
                Rectangle r = NodeWatcher.this.getTree().getVisibleRect();
                if (this._r != null && r.equals(this._r)) {
                    return;
                }
                this._r = r;
                NodeWatcher.this.updateVisibleNodes();
            }
        }

        private final class ParentListener
        implements AncestorListener {
            private ParentListener() {
            }

            @Override
            public final void ancestorAdded(AncestorEvent e) {
                NodeWatcher.this.removeInternalListeners();
                NodeWatcher.this.addInternalListeners();
            }

            @Override
            public final void ancestorMoved(AncestorEvent e) {
            }

            @Override
            public final void ancestorRemoved(AncestorEvent e) {
                NodeWatcher.this.removeInternalListeners();
            }
        }
    }
}

