/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dialogs.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.ide.dialogs.filter.FileFilter;
import oracle.ide.dialogs.filter.FileTypeIncludeFilter;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.WildcardURLFilter;
import oracle.ide.util.ModelUtil;
import oracle.javatools.util.Copyable;

public class DirectoryExcludeFilter
implements FileFilter,
Copyable {
    private boolean _recurseDirectories = true;
    private int _applyToDirectory = 0;
    private String _userDefinedExclusions;
    private String _oldUserDefinedExclusions;
    private ArrayList _userDefinedExceptionList = new ArrayList();

    @Override
    public List getList() {
        return this.parseUserDefinedFilterString();
    }

    @Override
    public boolean getRecurseDirectories() {
        return this._recurseDirectories;
    }

    @Override
    public void setRecurseDirectories(boolean recurseDirectories) {
        this._recurseDirectories = recurseDirectories;
    }

    @Override
    public int getApplyToDirectory() {
        return this._applyToDirectory;
    }

    @Override
    public void setApplyToDirectory(int applyToDirectory) {
        this._applyToDirectory = applyToDirectory;
    }

    @Override
    public String getUserDefinedExclusions() {
        return this._userDefinedExclusions;
    }

    @Override
    public void setUserDefinedExclusions(String userDefinedExclusions) {
        this._userDefinedExclusions = userDefinedExclusions;
    }

    public static boolean equals(DirectoryExcludeFilter f1, DirectoryExcludeFilter f2) {
        String f2excl;
        if (f1.getRecurseDirectories() != f2.getRecurseDirectories()) {
            return false;
        }
        if (f1.getApplyToDirectory() != f2.getApplyToDirectory()) {
            return false;
        }
        String f1excl = f1.getUserDefinedExclusions();
        return ModelUtil.areEqual((Object)f1excl, (Object)(f2excl = f2.getUserDefinedExclusions()));
    }

    protected List parseUserDefinedFilterString() {
        if (ModelUtil.areEqual((Object)this._userDefinedExclusions, (Object)this._oldUserDefinedExclusions)) {
            return this._userDefinedExceptionList;
        }
        if (!ModelUtil.hasLength((String)this._userDefinedExclusions)) {
            this._userDefinedExceptionList.clear();
        } else {
            int filterType;
            this._userDefinedExceptionList.clear();
            StringTokenizer st = new StringTokenizer(this._userDefinedExclusions, ";");
            int n = filterType = this instanceof FileTypeIncludeFilter ? 0 : 1;
            while (st.hasMoreTokens()) {
                URLFilter filter = null;
                String token = st.nextToken();
                filter = DirectoryExcludeFilter.createURLFilter(token, filterType);
                if (filter == null) continue;
                this._userDefinedExceptionList.add(filter);
            }
        }
        this._oldUserDefinedExclusions = this._userDefinedExclusions;
        return this._userDefinedExceptionList;
    }

    protected static URLFilter createURLFilter(String filterText, int filterType) {
        Object filter = null;
        filter = WildcardURLFilter.hasWildcard((String)filterText) ? new WildcardURLFilter(filterText, URLFileSystem.isLocalFileSystemCaseSensitive()) : (filterType == 0 || filterText.endsWith(" /") ? new DefaultURLFilter(filterText, filterText) : new DefaultURLFilter(filterText, filterText + "/"));
        return filter;
    }

    public Object copyTo(Object target) {
        DirectoryExcludeFilter copy = target != null ? (DirectoryExcludeFilter)target : new DirectoryExcludeFilter();
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(DirectoryExcludeFilter copy) {
        copy._recurseDirectories = this._recurseDirectories;
        copy._applyToDirectory = this._applyToDirectory;
        copy._userDefinedExclusions = this._userDefinedExclusions;
    }
}

