/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.beans.VetoableChangeListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogRunnerCallback;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.Assert;
import oracle.javatools.util.SwingUtils;

public final class OnePageWizardDialogFactory {
    private static final int DEFAULT_BUTTON_MASK = 7;

    private OnePageWizardDialogFactory() {
    }

    public static final JEWTDialog createJEWTDialog(Component content, Component defaultComp, String title) {
        return OnePageWizardDialogFactory.createJEWTDialog(content, defaultComp, title, 7);
    }

    public static final JEWTDialog createJEWTDialog(Component content, Component defaultComp, String title, int buttonMask) {
        return OnePageWizardDialogFactory.createJEWTDialog(SwingUtils.getToplevelWindow(), content, defaultComp, title, buttonMask);
    }

    public static final JEWTDialog createJEWTDialog(Component parent, Component content, Component defaultComp, String title, int buttonMask) {
        DialogHeader h;
        Dlg dlg;
        Object w = Ide.getMainWindow();
        while (parent != null) {
            if (parent instanceof Window) {
                w = (Window)parent;
                break;
            }
            parent = parent.getParent();
        }
        Dlg dlg2 = dlg = w instanceof Dialog ? new Dlg((Dialog)w, title, buttonMask) : new Dlg((Frame)w, title, buttonMask);
        if (null != defaultComp) {
            dlg.setInitialFocus(defaultComp);
        }
        dlg.setContent(content);
        dlg.setResizable(true);
        if (content instanceof JComponent && (h = (DialogHeader)((JComponent)content).getClientProperty("dialogHeader")) != null) {
            dlg.setDialogHeader((Component)h);
        }
        return dlg;
    }

    public static final boolean runDialog(Component content, String title) {
        return OnePageWizardDialogFactory.runDialog(content, null, title, 7, null);
    }

    public static final boolean runDialog(Component content, Component defComp, String title) {
        return OnePageWizardDialogFactory.runDialog(content, defComp, title, 7, null);
    }

    public static final boolean runDialog(Component parent, Component content, Component defComp, String title) {
        return OnePageWizardDialogFactory.runDialog(parent, content, defComp, title, 7, null);
    }

    public static final boolean runDialog(Component content, Component defComp, String title, int buttonMask) {
        return OnePageWizardDialogFactory.runDialog(content, defComp, title, buttonMask, null);
    }

    public static final boolean runDialog(Component content, Component defComp, String title, int buttonMask, VetoableChangeListener l) {
        return OnePageWizardDialogFactory.runDialog(content, defComp, title, buttonMask, l, null);
    }

    public static final boolean runDialog(Component content, Component defComp, String title, int buttonMask, VetoableChangeListener l, DialogRunnerCallback callback) {
        return OnePageWizardDialogFactory.runDialog(SwingUtils.getToplevelWindow(), content, defComp, title, buttonMask, l, callback);
    }

    public static final boolean runDialog(Component parent, Component content, Component defComp, String title, int buttonMask, VetoableChangeListener l) {
        return OnePageWizardDialogFactory.runDialog(parent, content, defComp, title, buttonMask, l, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean runDialog(Component parent, Component content, Component defComp, String title, int buttonMask, VetoableChangeListener l, DialogRunnerCallback callback) {
        JEWTDialog dlg = null;
        boolean ok = false;
        try {
            dlg = OnePageWizardDialogFactory.createJEWTDialog(parent, content, defComp, title, buttonMask);
            if (l != null) {
                dlg.addVetoableChangeListener(l);
            }
            if (callback != null) {
                callback.dialogAboutToRun((JDialog)dlg);
            }
            ok = WizardLauncher.runDialog((JDialog)dlg);
        }
        finally {
            if (l != null && dlg != null) {
                try {
                    dlg.removeVetoableChangeListener(l);
                }
                catch (Exception ex) {
                    Assert.printStackTrace((Throwable)ex);
                }
            }
            dlg = null;
        }
        return ok;
    }

    public static final void setDialogHeader(Component content, DialogHeader header) {
        if (content instanceof JComponent) {
            ((JComponent)content).putClientProperty("dialogHeader", header);
        }
    }

    private static class Dlg
    extends JEWTDialog {
        private static final String DFT_SYMBOL = "one-page-wizard";
        private static final int MAX_INITIAL_WIDTH = 700;
        private static final int MAX_INITIAL_HEIGHT = 500;

        private Dlg(Frame parent, String title, int buttonMask) {
            super(parent, title, buttonMask);
            this.setName(DFT_SYMBOL);
        }

        private Dlg(Dialog parent, String title, int buttonMask) {
            super(parent, title, buttonMask);
            this.setName(DFT_SYMBOL);
        }

        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            if (dim.width > 700 || dim.height > 500) {
                dim.setSize(Math.min(dim.width, 700), Math.min(dim.height, 500));
            }
            return dim;
        }
    }
}

