/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Image;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.controller.PropertyResolver;
import oracle.ide.controls.KeyboardRedirector;
import oracle.ide.nulls.NullIcon;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.JDK;
import oracle.javatools.ui.GraphicsUtils;

public abstract class ToggleAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(ToggleAction.class.getName());
    private final List _resolvers = new ArrayList();
    @Deprecated
    public static final String ACTION = "Action";
    @Deprecated
    public static final String MNEMONIC = "MnemonicKey";
    public static final String ACCELERATOR = "Accelerator";
    public static final String USER_DATA = "UserData";
    public static final String DISABLED_ICON = "DisabledIcon";
    public static final String TOGGLES = "Check";
    public static final String RADIO = "Radio";
    public static final String STATE = "State";
    public static final String HIDDEN = "Hidden";
    public static final String BUTTON_GROUP_NAME = "RadioGroupName";
    public static final String ACTION_MENU_ACTIONS = "ActionMenuActions";
    public static final String ACTION_MENU_HAS_DEFAULT_ACTION = "ActionMenuHasDefaultAction";
    public static final String MENU_WEIGHT = "menu-weight";
    public static final float MENU_WEIGHT_UNASSIGNED = Float.MAX_VALUE;
    public static final String CATEGORY = "Category";
    public static final String CONTEXT_INDEPENDENT_NAME = "NoCtxName";
    public static final String CAN_BE_PLACED_ON_MAIN_TOOLBAR = "CanBePlacedOnMainToolbar";
    @Deprecated
    protected static final boolean PERFORM_ACTION_LATER = false;

    public ToggleAction(String name, Icon icon) {
        this.setName(name);
        this.putValue("SmallIcon", icon);
    }

    public ToggleAction(String name, ResourceBundle bundle, String iconPath) {
        this(name, null);
        if (bundle != null && iconPath != null && !iconPath.equals("")) {
            this.addPropertyResolver(new ResourceBundleIconResolver(bundle, iconPath));
        }
    }

    public ToggleAction(String name, ArrayResourceBundle bundle, int key) {
        this(name, null);
        if (bundle != null && key >= 0) {
            this.addPropertyResolver(new ArbIconResolver(bundle, key));
        }
    }

    protected ToggleAction(ToggleAction action) {
        if (action != null) {
            Object[] keys = action.getKeys();
            if (keys != null) {
                for (Object key : keys) {
                    String str = key.toString();
                    this.putValue(str, action.getValue(str));
                }
            }
            this._resolvers.addAll(action._resolvers);
        }
    }

    public final void addPropertyResolver(PropertyResolver resolver) {
        if (resolver == null) {
            throw new NullPointerException("resolver is null");
        }
        this._resolvers.add(0, resolver);
    }

    public final void removePropertyResolver(PropertyResolver resolver) {
        this._resolvers.remove(resolver);
    }

    public boolean getState() {
        return this.getBooleanValue(STATE);
    }

    public void setState(boolean b) {
        this.setBooleanValue(STATE, b);
    }

    @Override
    public void putValue(String key, Object newValue) {
        if ("SwingSelectedKey".equals(key)) {
            this.setState((Boolean)newValue);
        } else {
            super.putValue(key, newValue);
        }
    }

    public boolean isToggle() {
        return this.getBooleanValue(TOGGLES);
    }

    public boolean isRadio() {
        return this.getBooleanValue(RADIO);
    }

    public boolean isActionMenu() {
        return this.getValue(ACTION_MENU_ACTIONS) != null;
    }

    public void setName(String name) {
        int keyCode = StringUtils.getMnemonicKeyCode((String)name);
        if (keyCode != 0) {
            this.putValue(MNEMONIC, keyCode);
            this.putValue("Name", StringUtils.stripMnemonic((String)name));
        } else {
            this.putValue("Name", name);
        }
    }

    public void setMenuWeight(float weight) {
        this.putValue(MENU_WEIGHT, new Float(weight));
    }

    public float getMenuWeight() {
        Object f = this.getValue(MENU_WEIGHT);
        if (f == null) {
            return Float.MAX_VALUE;
        }
        return ((Float)f).floatValue();
    }

    protected boolean getBooleanValue(String key) {
        Object value = this.getValue(key);
        return value instanceof Boolean && (Boolean)value != false;
    }

    protected void setBooleanValue(String key, boolean newValue) {
        boolean oldValue = this.getBooleanValue(key);
        if (oldValue != newValue) {
            this.putValue(key, newValue);
        }
    }

    private Object getValueFromResolvers(String key) {
        Object o = null;
        for (PropertyResolver resolver : this._resolvers) {
            try {
                o = resolver.get(key);
            }
            catch (Exception e) {
                String name = (String)super.getValue("Name");
                String msg = name != null ? "*** Invalid menu " + name : "*** NULL menu name";
                LOG.log(Level.SEVERE, msg, e);
            }
            if (o == null) continue;
            return o;
        }
        return o;
    }

    public void listenForItemEvent(AbstractButton button) {
        button.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object src = e.getSource();
                if (src instanceof AbstractButton) {
                    final AbstractButton button = (AbstractButton)src;
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            boolean selected = button.isSelected();
                            if (ToggleAction.this.getState() != selected) {
                                ToggleAction.this.setState(selected);
                            }
                        }
                    };
                    runnable.run();
                }
            }
        });
    }

    @Override
    public Object getValue(String key) {
        if ("SwingSelectedKey".equals(key)) {
            return this.getState();
        }
        Object o = super.getValue(key);
        if (o == null) {
            Icon icon;
            o = this.getValueFromResolvers(key);
            if (o != null) {
                this.putValue(key, o);
            }
            if (key == DISABLED_ICON && (icon = (Icon)this.getValue("SmallIcon")) instanceof ImageIcon) {
                o = GraphicsUtils.createImageIcon((Image)GrayFilter.createDisabledImage(((ImageIcon)icon).getImage()));
                this.putValue(key, o);
                return o;
            }
        }
        if (CAN_BE_PLACED_ON_MAIN_TOOLBAR.equals(key) && (!(o instanceof Boolean) || Boolean.TRUE.equals(o) && this.isToggle())) {
            o = Boolean.FALSE;
            this.putValue(key, o);
        }
        return o;
    }

    protected static final void freezeKeyboard(boolean freeze) {
        if (JDK.HAS_BUG_BROKEN_TYPE_AHEAD) {
            KeyboardRedirector keyboardRedirector = KeyboardRedirector.getInstance();
            if (freeze) {
                keyboardRedirector.freeze();
            } else {
                keyboardRedirector.thaw();
            }
        }
    }

    public String toString() {
        return super.toString() + " \"" + this.getValue("Name") + '\"';
    }

    private static final class ArbIconResolver
    extends PropertyResolver {
        private ArrayResourceBundle _bundle;
        private final int _iconKey;

        private ArbIconResolver(ArrayResourceBundle bundle, int iconKey) {
            this._bundle = bundle;
            this._iconKey = iconKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get(String key) {
            if (this._bundle != null && "SmallIcon" == key) {
                try {
                    Icon icon = this._bundle.getIconImpl(this._iconKey);
                    return icon;
                }
                catch (Exception e) {
                    NullIcon nullIcon = new NullIcon();
                    return nullIcon;
                }
                finally {
                    this._bundle = null;
                }
            }
            return null;
        }
    }

    private static final class ResourceBundleIconResolver
    extends PropertyResolver {
        private ResourceBundle _bundle;
        private String _key;

        private ResourceBundleIconResolver(ResourceBundle bundle, String key) {
            this._bundle = bundle;
            this._key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get(String key) {
            if (this._bundle != null && "SmallIcon" == key) {
                try {
                    URL url = this._bundle.getClass().getResource(this._key);
                    ImageIcon icon = GraphicsUtils.createImageIcon((URL)url);
                    if (icon == null) {
                        icon = new NullIcon();
                    }
                    ImageIcon imageIcon = icon;
                    return imageIcon;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    NullIcon nullIcon = new NullIcon();
                    return nullIcon;
                }
                finally {
                    this._bundle = null;
                    this._key = null;
                }
            }
            return null;
        }
    }
}

