/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.ide.controls.Animator;

public class LayoutAnimator {
    private HashMap<Component, Entry> _before;
    private Container _container;

    public LayoutAnimator(Container container) {
        container.getParent().validate();
        this._container = container;
        this._before = new HashMap();
        this.record(container, this._before);
    }

    private void record(Component component, HashMap<Component, Entry> snapshot) {
        Entry entry = new Entry(component);
        snapshot.put(component, entry);
        if (component instanceof Container) {
            Container container = (Container)component;
            int size = container.getComponentCount();
            for (int i = 0; i < size; ++i) {
                Component child = container.getComponent(i);
                this.record(child, snapshot);
            }
        }
    }

    public void animate(int stepTime, long maxTime, int steps, double center, double sigma, final PropertyChangeListener propertyChangeListener) {
        this._container.getParent().validate();
        final HashMap<Component, Entry> after = new HashMap<Component, Entry>(this._before.size());
        this.record(this._container, after);
        final ArrayList<Component> components = new ArrayList<Component>();
        Set<Map.Entry<Component, Entry>> entrySetBefore = this._before.entrySet();
        for (Map.Entry<Component, Entry> mapEntryBefore : entrySetBefore) {
            Component component = mapEntryBefore.getKey();
            Entry valueAfter = after.get(component);
            if (valueAfter == null) continue;
            Entry valueBefore = mapEntryBefore.getValue();
            if (valueBefore._visible && !valueAfter._visible) {
                valueAfter._bounds.setBounds(valueBefore._bounds);
                Container parent = component.getParent();
                parent.setComponentZOrder(component, parent.getComponentCount() - 1);
                component.setVisible(true);
            }
            if (!valueBefore._visible && valueAfter._visible) {
                valueBefore._bounds.setBounds(valueAfter._bounds);
            }
            components.add(component);
        }
        Animator.animate(stepTime, 100000L, steps, center, sigma, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Double newValue = (Double)evt.getNewValue();
                double r = newValue;
                LayoutAnimator.animate(components, LayoutAnimator.this._before, after, r);
                if (propertyChangeListener != null) {
                    propertyChangeListener.propertyChange(evt);
                }
                Graphics graphics = LayoutAnimator.this._container.getGraphics();
                LayoutAnimator.this._container.paint(graphics);
                graphics.dispose();
            }
        });
        Set<Map.Entry<Component, Entry>> entrySetAfter = after.entrySet();
        for (Map.Entry<Component, Entry> mapEntryAfter : entrySetAfter) {
            Component component = mapEntryAfter.getKey();
            Entry value = mapEntryAfter.getValue();
            component.setVisible(value._visible);
        }
    }

    private static void animate(ArrayList<Component> components, HashMap<Component, Entry> before, HashMap<Component, Entry> after, double r) {
        for (int i = 0; i < components.size(); ++i) {
            Component component = components.get(i);
            Entry entryBefore = before.get(component);
            Entry entryAfter = after.get(component);
            Rectangle boundsBefore = entryBefore._bounds;
            Rectangle boundsAfter = entryAfter._bounds;
            component.setBounds((int)((double)boundsBefore.x + (double)(boundsAfter.x - boundsBefore.x) * r), (int)((double)boundsBefore.y + (double)(boundsAfter.y - boundsBefore.y) * r), (int)((double)boundsBefore.width + (double)(boundsAfter.width - boundsBefore.width) * r), (int)((double)boundsBefore.height + (double)(boundsAfter.height - boundsBefore.height) * r));
        }
    }

    private static class Entry {
        private Rectangle _bounds;
        private boolean _visible;

        public Entry(Component component) {
            this._visible = component.isVisible();
            this._bounds = this._visible ? component.getBounds() : new Rectangle();
        }
    }
}

