/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class ItemSelectableTracker
implements ItemListener {
    private ItemSelectable item;
    protected Component[] components;
    protected ItemSelectableTracker[] trackers;
    private boolean sameEnabledState;

    public ItemSelectableTracker(ItemSelectable selectableItem, Component[] dependentComponents) {
        this(selectableItem, dependentComponents, null, true);
    }

    public ItemSelectableTracker(ItemSelectable selectableItem, Component[] dependentComponents, ItemSelectableTracker[] dependentTrackers) {
        this(selectableItem, dependentComponents, dependentTrackers, true);
    }

    public ItemSelectableTracker(ItemSelectable selectableItem, Component[] dependentComponents, boolean sameEnabledState) {
        this(selectableItem, dependentComponents, null, sameEnabledState);
    }

    private ItemSelectableTracker(ItemSelectable selectableItem, Component[] dependentComponents, ItemSelectableTracker[] dependentTrackers, boolean sameEnabledState) {
        this.item = selectableItem;
        this.components = dependentComponents;
        this.trackers = dependentTrackers;
        this.sameEnabledState = sameEnabledState;
        selectableItem.addItemListener(this);
        Object[] selectedObjects = this.item.getSelectedObjects();
        boolean isSelected = selectedObjects != null;
        this.updateItemState(isSelected);
    }

    @Override
    public final void itemStateChanged(ItemEvent event) {
        ItemSelectable selectableItem = event.getItemSelectable();
        if (selectableItem == this.item) {
            int selected = event.getStateChange();
            boolean isSelected = selected == 1;
            this.updateItemState(isSelected);
        }
    }

    private void updateItemState(boolean isSelected) {
        boolean newState = this.sameEnabledState ? isSelected : !isSelected;
        int numComponents = this.components == null ? 0 : this.components.length;
        for (int i = 0; i < numComponents; ++i) {
            Component component = this.components[i];
            if (component == null) continue;
            component.setEnabled(newState);
        }
        int numTrackers = this.trackers == null ? 0 : this.trackers.length;
        for (int i = 0; i < numTrackers; ++i) {
            Object[] selectedObjects;
            ItemSelectableTracker tracker = this.trackers[i];
            ItemSelectable childSelectable = tracker.item;
            if (childSelectable instanceof Component) {
                ((Component)((Object)childSelectable)).setEnabled(newState);
            }
            boolean isChildSelected = (selectedObjects = childSelectable.getSelectedObjects()) != null && newState;
            tracker.updateItemState(isChildSelected);
        }
        if (isSelected) {
            this.itemSelected(this.item);
        } else {
            this.itemDeselected(this.item);
        }
    }

    protected void itemSelected(ItemSelectable item) {
    }

    protected void itemDeselected(ItemSelectable item) {
    }
}

