/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import oracle.ide.feedback.FeedbackManager;

public final class GlobalMouseDispatcher
implements AWTEventListener {
    private ArrayList _listeners = new ArrayList(5);
    private static GlobalMouseDispatcher INSTANCE;

    private GlobalMouseDispatcher() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        tk.addAWTEventListener(this, 16L);
    }

    public static synchronized GlobalMouseDispatcher getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GlobalMouseDispatcher();
        }
        return INSTANCE;
    }

    public void addMouseListener(MouseListener l) {
        this._listeners.add(l);
    }

    public void removeMouseListener(MouseListener l) {
        this._listeners.remove(l);
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        Point pt;
        MouseEvent e = (MouseEvent)event;
        Component src = e.getComponent();
        Component deeper = this.getDeepestComponent(src, pt = new Point(e.getPoint()));
        if (deeper != src) {
            e = new MouseEvent(deeper, e.getID(), e.getWhen(), e.getModifiers(), pt.x, pt.y, e.getClickCount(), e.isPopupTrigger());
        }
        MouseListener[] listeners = new MouseListener[this._listeners.size()];
        this._listeners.toArray(listeners);
        for (int i = 0; i < listeners.length; ++i) {
            MouseListener l = listeners[i];
            if (l == null) continue;
            try {
                switch (e.getID()) {
                    case 500: {
                        l.mouseClicked(e);
                        break;
                    }
                    case 504: {
                        l.mouseEntered(e);
                        break;
                    }
                    case 505: {
                        l.mouseExited(e);
                        break;
                    }
                    case 501: {
                        l.mousePressed(e);
                        break;
                    }
                    case 502: {
                        l.mouseReleased(e);
                    }
                }
                continue;
            }
            catch (Exception ex) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        FeedbackManager.reportException(ex);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    private Component getDeepestComponent(Component src, Point pt) {
        Container parent;
        Component sub;
        while (src instanceof Container && (sub = (parent = (Container)src).getComponentAt(pt)) != src && sub != null) {
            SwingUtilities.convertPoint(src, pt, sub);
            src = sub;
        }
        return src;
    }
}

