/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class DescriptionScrollPane
extends JScrollPane {
    private static final Border NO_FOCUS_BORDER = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    private static final Border OUTER_FOCUS_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private final EventHandler _eventHandler = new EventHandler();
    private final JTextPane _textPane = new JTextPane();

    public DescriptionScrollPane() {
        Border noFocusBorder = DescriptionScrollPane.getNoFocusBorder();
        this.setViewportBorder(noFocusBorder);
        this.setViewportView(this._textPane);
        this._textPane.setEditable(false);
        this._textPane.setOpaque(false);
        this._textPane.setBorder(noFocusBorder);
        this._textPane.addFocusListener(this._eventHandler);
        this._textPane.getAccessibleContext().setAccessibleDescription("");
    }

    public void setText(String text) {
        this._textPane.setText(text);
        this._textPane.setCaretPosition(0);
        this._textPane.getAccessibleContext().setAccessibleName(text);
    }

    public String getText() {
        return this._textPane.getText();
    }

    public Component getLabelComponent() {
        return this._textPane;
    }

    private static Border getFocusBorder() {
        Border innerFocusBorder = UIManager.getBorder("List.focusCellHighlightBorder");
        return BorderFactory.createCompoundBorder(OUTER_FOCUS_BORDER, innerFocusBorder);
    }

    private static Border getNoFocusBorder() {
        return NO_FOCUS_BORDER;
    }

    private final class EventHandler
    implements FocusListener {
        private EventHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            Border border = DescriptionScrollPane.getFocusBorder();
            DescriptionScrollPane.this.setViewportBorder(border);
            DescriptionScrollPane.this.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            Border border = DescriptionScrollPane.getNoFocusBorder();
            DescriptionScrollPane.this.setViewportBorder(border);
            DescriptionScrollPane.this.repaint();
        }
    }
}

