/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.MutableComboBoxModel;
import oracle.ide.resource.ControlsArb;

public abstract class AbstractPicker
extends JComboBox
implements ActionListener {
    protected PickerResultValidator validator = null;
    protected PickerValueEncoder encoder = null;
    private boolean editing = false;

    public AbstractPicker() {
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (AbstractPicker.this.editing) {
                    AbstractPicker.this.editFinished();
                }
            }
        });
        if (this.getEditor() != null) {
            Component editComp = this.getEditor().getEditorComponent();
            editComp.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    AbstractPicker.this.editing = true;
                }

                @Override
                public void focusLost(FocusEvent e) {
                    AbstractPicker.this.editFinished();
                }
            });
        }
    }

    public PickerResultValidator getValidator() {
        return this.validator;
    }

    public void setValidator(PickerResultValidator newValidator) {
        this.validator = newValidator;
    }

    public PickerValueEncoder getEncoder() {
        return this.encoder;
    }

    public void setEncoder(PickerValueEncoder newEncoder) {
        this.encoder = newEncoder;
    }

    public Object getCurrentValue() {
        return this.getSelectedItem();
    }

    @Override
    public Object getSelectedItem() {
        if (this.editing) {
            this.editFinished();
        }
        return super.getSelectedItem();
    }

    public void setCurrentValue(Object newCurrentValue) {
        this.setSelectedItem(newCurrentValue);
    }

    @Override
    public void setSelectedItem(Object newValue) {
        this.getCurrentValue();
        this.addValue(newValue);
        super.setSelectedItem(newValue);
    }

    protected String getInvalidValueErrorTitle() {
        return ControlsArb.getString(11);
    }

    protected String getInvalidValueErrorHelpID() {
        return null;
    }

    public final void setBrowseResult(Object result) {
        if (result == null) {
            return;
        }
        if (this.validator == null || this.validator.isResultValid(result)) {
            Object value = this.encoder != null ? this.encoder.encodeValue(result) : result;
            this.setCurrentValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addValue(Object value) {
        MutableComboBoxModel model;
        if (value == null || value.toString().length() == 0) {
            return;
        }
        MutableComboBoxModel mutableComboBoxModel = model = (MutableComboBoxModel)this.getModel();
        synchronized (mutableComboBoxModel) {
            for (int i = 0; i < model.getSize(); ++i) {
                if (!model.getElementAt(i).equals(value)) continue;
                return;
            }
            model.addElement(value);
        }
    }

    private void editFinished() {
        this.editing = false;
        Object result = this.getEditor().getItem();
        this.setBrowseResult(result);
    }

    @Override
    public void requestFocus() {
        if (this.isEditable()) {
            if (this.getEditor() != null) {
                this.getEditor().getEditorComponent().requestFocus();
            }
        } else {
            super.requestFocus();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (this.getEditor() != null && (src == this.getEditor() || src == this.getEditor().getEditorComponent())) {
            super.actionPerformed(ae);
        } else {
            this.doBrowse();
        }
    }

    protected abstract void doBrowse();

    public static interface PickerResultValidator {
        public boolean isResultValid(Object var1);

        public String getInvalidValueMsg(Object var1);
    }

    public static interface PickerValueEncoder {
        public Object encodeValue(Object var1);
    }
}

