/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.awt.Component;
import java.awt.Container;
import javax.swing.JComponent;
import oracle.ide.config.SettingsFieldCustomizations;
import oracle.ide.config.SettingsUIRegistry;
import oracle.ide.panels.Traversable;

public final class SettingsPageCustomizationHelper {
    private final Traversable _panel;
    private final String _pageIdPath;
    private static final String CP_FIELD_ID = "__oracleide_fieldid";

    SettingsPageCustomizationHelper(Traversable panel, String pageIdPath) {
        this._panel = panel;
        this._pageIdPath = pageIdPath;
    }

    public void setFieldId(JComponent c, String fieldId) {
        c.putClientProperty(CP_FIELD_ID, fieldId);
    }

    public void customizeComponents() {
        Component root = this._panel.getComponent();
        if (root instanceof Container) {
            Container rootContainer = (Container)root;
            this.customizeComponents(rootContainer);
            root.validate();
        }
    }

    private void customizeComponents(Container container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component child = container.getComponent(i);
            if (child != null && child instanceof JComponent) {
                this.customizeComponent((JComponent)child);
            }
            if (!(child instanceof Container)) continue;
            this.customizeComponents((Container)child);
        }
    }

    private void customizeComponent(JComponent component) {
        SettingsFieldCustomizations customization;
        String fieldId = (String)component.getClientProperty(CP_FIELD_ID);
        if (fieldId != null && (customization = this.getCustomizations(fieldId)) != null) {
            component.setEnabled(customization.isEnabled());
            component.setVisible(customization.isVisible());
        }
    }

    public SettingsFieldCustomizations getCustomizations(String fieldId) {
        return SettingsUIRegistry.getCustomizations().getFieldCustomizations(this._pageIdPath + "/" + fieldId);
    }
}

