/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.net.URL;
import java.text.DateFormat;
import oracle.ide.cmd.HistoryGeneratingCommand;
import oracle.ide.cmd.RevertNodeCommand;
import oracle.ide.history.HistoryContext;
import oracle.ide.history.LocalState;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;

public class RestoreHistoryCommand
extends RevertNodeCommand
implements HistoryGeneratingCommand {
    @Override
    public String getName() {
        LocalState state = HistoryContext.getLocalState(this.getContext());
        DateFormat format = DateFormat.getDateTimeInstance();
        String date = format.format(state.getDate());
        return IdeArb.format(447, new String[]{date});
    }

    @Override
    public int doit() throws Exception {
        LocalState state = HistoryContext.getLocalState(this.getContext());
        URL nodeUrl = state.getNodeURL();
        URL stateUrl = state.getStateURL();
        URL dataUrl = state.getDataURL();
        if (nodeUrl == null) {
            throw new Exception("Object has been deleted.");
        }
        if (!URLFileSystem.equals((URL)nodeUrl, (URL)stateUrl)) {
            throw new Exception("Object has been renamed.");
        }
        URLFileSystem.copy((URL)dataUrl, (URL)stateUrl);
        return super.doit();
    }

    @Override
    public Node[] getHistoriedNodes() {
        return new Node[]{this.getContext().getNode()};
    }

    @Override
    public boolean isGeneratePrecedingState() {
        return this.getHistoriedNodes()[0].isDirty();
    }
}

