/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.net.URL;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

public final class RenameMessage {
    private static final String IS_PRE_RENAME_MESSAGE = "RenameMessage.IS_PRE_RENAME_MESSAGE";
    private static final String RENAMED_NODE = "RenameMessage.RENAMED_NODE";

    private RenameMessage() {
    }

    public static boolean isPreRenameMessage(UpdateMessage message) {
        if (message != null) {
            return Boolean.TRUE.equals(message.getProperty(IS_PRE_RENAME_MESSAGE));
        }
        return false;
    }

    public static void setPreRenameMessage(UpdateMessage message, boolean isPreRenameMessage) {
        if (message != null) {
            message.setProperty(IS_PRE_RENAME_MESSAGE, isPreRenameMessage);
        }
    }

    public static URL getOldURL(UpdateMessage message) {
        Object obj;
        List objs = message.getModifyObjects();
        if (objs.size() > 0 && (obj = objs.get(0)) instanceof URL) {
            return (URL)obj;
        }
        return null;
    }

    public static Node getRenamedNode(UpdateMessage message) {
        if (message != null) {
            return (Node)message.getProperty(RENAMED_NODE);
        }
        return null;
    }

    public static void setRenamedNode(UpdateMessage message, Node renamedNode) {
        if (message != null) {
            message.setProperty(RENAMED_NODE, renamedNode);
        }
    }

    public static Node getRemovedNode(UpdateMessage message) {
        Object obj;
        List objs = message.getRemoveObjects();
        if (objs.size() > 0 && (obj = objs.get(0)) instanceof Node) {
            return (Node)obj;
        }
        return null;
    }

    public static Node getNewNode(UpdateMessage message) {
        Object obj;
        List objs = message.getAddObjects();
        if (objs.size() > 0 && (obj = objs.get(0)) instanceof Node) {
            return (Node)obj;
        }
        return null;
    }

    public static void fireObjectRenamed(Subject subject, URL oldURL, Context context) {
        UpdateMessage msg = new UpdateMessage(UpdateMessage.OBJECT_RENAMED, null);
        msg.getModifyObjects().add(oldURL);
        msg.setContext(context);
        RenameMessage.setRenamedNode(msg, context.getNode());
        subject.notifyObservers(subject, msg);
    }

    public static void fireChildRenamed(Subject subject, URL oldURL, Node node, Context context) {
        UpdateMessage msg = new UpdateMessage(UpdateMessage.CHILD_RENAMED, null);
        msg.getModifyObjects().add(oldURL);
        msg.getModifyObjects().add(node);
        msg.getAddObjects().add(context.getElement());
        msg.setContext(context);
        RenameMessage.setRenamedNode(msg, node);
        subject.notifyObservers(subject, msg);
    }

    public static void fireObjectRenamed(Subject subject, URL oldURL, Node node, Node duplicate, Context context) {
        UpdateMessage msg = new UpdateMessage(UpdateMessage.OBJECT_RENAMED, null);
        if (duplicate != null) {
            msg.getAddObjects().add(duplicate);
        }
        msg.getRemoveObjects().add(node);
        msg.getModifyObjects().add(oldURL);
        msg.setContext(context);
        if (duplicate == null) {
            RenameMessage.setRenamedNode(msg, node);
            node.notifyObservers(node, msg);
        } else {
            RenameMessage.setRenamedNode(msg, duplicate);
            node.notifyObservers(duplicate, msg);
        }
    }

    public static void fireChildRenamed(Subject subject, URL oldURL, Node node, Node duplicate, Context context) {
        UpdateMessage msg = new UpdateMessage(UpdateMessage.CHILD_RENAMED, null);
        if (duplicate == null) {
            RenameMessage.setRenamedNode(msg, node);
        } else {
            RenameMessage.setRenamedNode(msg, duplicate);
        }
        if (duplicate != null) {
            msg.getAddObjects().add(duplicate);
        }
        msg.getRemoveObjects().add(node);
        msg.getModifyObjects().add(oldURL);
        msg.setContext(context);
        msg.getModifyObjects().add(subject);
        subject.notifyObservers(subject, msg);
    }

    public static void fireObjectRenamed(Node doc, URL oldURL, Node node, Context context) {
        UpdateMessage msg = new UpdateMessage(UpdateMessage.OBJECT_RENAMED, null);
        RenameMessage.setRenamedNode(msg, doc);
        msg.getAddObjects().add(node);
        msg.getRemoveObjects().add(doc);
        msg.getModifyObjects().add(oldURL);
        msg.setContext(context);
        doc.notifyObservers(doc, msg);
    }

    public static void fireChildRenamed(Subject subject, Node doc, URL oldURL, Node node, Context context) {
        UpdateMessage msg = new UpdateMessage(UpdateMessage.CHILD_RENAMED, null);
        RenameMessage.setRenamedNode(msg, doc);
        msg.getAddObjects().add(node);
        msg.getRemoveObjects().add(doc);
        msg.getModifyObjects().add(oldURL);
        msg.setContext(context);
        subject.notifyObservers(subject, msg);
    }

    public static void firePreChildRenamed(Subject subject, Context context) {
        UpdateMessage msg = new UpdateMessage(UpdateMessage.CHILD_RENAMED, null);
        RenameMessage.setPreRenameMessage(msg, true);
        msg.getRemoveObjects().add(context.getElement());
        msg.setContext(context);
        subject.notifyObservers(subject, msg);
    }
}

