/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.olap.provider.reader;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.table.Queries;
import oracle.olapdv.connection.ConnectionManager;
import oracle.olapdv.olap.model.AttributeDO;
import oracle.olapdv.olap.model.DimensionDO;
import oracle.olapdv.olap.model.HierarchyDO;
import oracle.olapdv.olap.model.LevelDO;

public class DimensionReader {
    private static Queries queries;
    private static final String XMLFILE = "olapdvreaderqueries.xml";
    private Logger LOG = Logger.getLogger(DimensionReader.class.getName());
    private final String GET_HIERARCHY_NAME_AND_TYPE = "get_hierarchy_name_and_type";
    private final String GET_ATTRIBUTE_DETAILS = "get_attribute_details";
    private final String GET_HIERARCHY_LEVEL_DETAILS = "get_hierarchy_level_details";
    private String m_awName;
    private String m_owner;

    public DimensionReader(String string, String string2) {
        this.m_owner = string;
        this.m_awName = string2;
    }

    private String getQuery(String string) {
        if (queries == null) {
            try {
                String string2 = "oracle.olap.app.table";
                String string3 = JavaXMLBind.LoadDocument(this.getClass(), (String)XMLFILE);
                JavaXMLBind.BindToJavaStr((String)string3, (String)string2, (Object)this);
            }
            catch (Exception exception) {
                this.LOG.log(Level.WARNING, exception.getLocalizedMessage(), exception);
            }
        }
        return queries.getSQL(string);
    }

    public void addQueries(Queries queries) {
        DimensionReader.queries = queries;
    }

    public ArrayList<HierarchyDO> getHierarchyDOs(String string) {
        String string2 = this.getQuery("get_hierarchy_name_and_type");
        Connection connection = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method getHierarchyDOs, SQL Exception occurred.", sQLException);
        }
        ArrayList<HierarchyDO> arrayList = new ArrayList<HierarchyDO>();
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        dBUtil.setRaiseError(true);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("OWNER", this.m_owner);
        hashMap.put("DIMENSION_NAME", string);
        List list = dBUtil.executeReturnList(string2, hashMap);
        for (Map map : list) {
            HierarchyDO hierarchyDO = new HierarchyDO((String)map.get("HIERARCHY_NAME"));
            arrayList.add(hierarchyDO);
        }
        return arrayList;
    }

    public ArrayList<AttributeDO> getAttributeDOs(DimensionDO dimensionDO) {
        String string = this.getQuery("get_attribute_details");
        Connection connection = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method getAttributeDOs, SQL Exception occurred.", sQLException);
        }
        ArrayList<AttributeDO> arrayList = new ArrayList<AttributeDO>();
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        dBUtil.setRaiseError(true);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("OWNER", this.m_owner);
        hashMap.put("DIMENSION_NAME", dimensionDO.getName());
        List list = dBUtil.executeReturnList(string, hashMap);
        for (Map map : list) {
            AttributeDO attributeDO = new AttributeDO((String)map.get("ATTRIBUTE_NAME"));
            attributeDO.setAttributeRole((String)map.get("ATTRIBUTE_ROLE"));
            arrayList.add(attributeDO);
        }
        return arrayList;
    }

    public ArrayList<LevelDO> getHierarchyLevelDOs(DimensionDO dimensionDO) {
        String string = this.getQuery("get_hierarchy_level_details");
        Connection connection = null;
        String string2 = null;
        String string3 = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method getHierarchyLevelDOs, SQL Exception occurred.", sQLException);
        }
        ArrayList<LevelDO> arrayList = new ArrayList<LevelDO>();
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        dBUtil.setRaiseError(true);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("OWNER", this.m_owner);
        hashMap.put("DIMENSION_NAME", dimensionDO.getName());
        List list = dBUtil.executeReturnList(string, hashMap);
        for (Map map : list) {
            string2 = (String)map.get("HIERARCHY_NAME");
            string3 = (String)map.get("LEVEL_NAME");
            HierarchyDO hierarchyDO = dimensionDO.getHierarchyDOFromName(string2);
            LevelDO levelDO = new LevelDO(hierarchyDO, string3);
            BigDecimal bigDecimal = (BigDecimal)map.get("ORDER_NUM");
            levelDO.setDepth(bigDecimal.intValue() + 1);
            hierarchyDO.addLevelDO(levelDO);
            arrayList.add(levelDO);
        }
        return arrayList;
    }
}

