/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.olap.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.olapdv.OLAPDVArb;
import oracle.olapdv.olap.model.DataObject;
import oracle.olapdv.olap.model.DimensionDO;
import oracle.olapdv.olap.model.HierarchyDO;
import oracle.olapdv.olap.model.LevelDO;
import oracle.olapdv.olap.model.LevelMapDO;
import oracle.olapdv.olap.model.MessageDO;

public class ValidateModelDO
extends DataObject {
    private ArrayList<DimensionDO> m_dimDOs = null;
    private List<String> m_dimensionListCache = new ArrayList<String>();
    private String m_schemaName;
    private boolean m_modelChangesPending = false;
    private boolean m_validateReportUpdatesPending = false;
    private boolean m_didImport = false;
    private String m_lastTimeValidated;
    private Map<String, String> m_lastTimeValidatedMap = null;
    private String m_messageDimensionFilter = "All Dimensions";
    private boolean m_disableReport = false;
    private boolean m_launchedFromCache;

    public ValidateModelDO() {
    }

    public ValidateModelDO(String string, String string2) {
        super(string2);
        this.m_schemaName = string;
        this.initializeLastTimeValidatedMap();
    }

    private void initializeLastTimeValidatedMap() {
        this.m_lastTimeValidatedMap = new HashMap<String, String>();
        this.m_lastTimeValidatedMap.put("Distinct Members", null);
        this.m_lastTimeValidatedMap.put("Distinct Members And Descriptions", null);
        this.m_lastTimeValidatedMap.put("Duplicate Members Across Levels", null);
        this.m_lastTimeValidatedMap.put("Rows With Null Members", null);
        this.m_lastTimeValidatedMap.put("Members With Null Descriptions", null);
        this.m_lastTimeValidatedMap.put("Members With Multiple Descriptions", null);
        this.m_lastTimeValidatedMap.put("Descriptions With Multiple Members", null);
        this.m_lastTimeValidatedMap.put("Members With Multiple Parents", null);
        this.m_lastTimeValidatedMap.put("Descriptions With Multiple Parent Descriptions", null);
    }

    public String getModelOwner() {
        return this.m_schemaName;
    }

    public boolean isEmpty() {
        boolean bl = false;
        bl = this.m_dimDOs == null ? true : this.m_dimDOs.size() == 0;
        return bl;
    }

    public void resetDepthAfterErrorFromCreateFromAW() {
        ArrayList<DimensionDO> arrayList = this.getDimensionDOs();
        for (DimensionDO dimensionDO : arrayList) {
            ArrayList<HierarchyDO> arrayList2 = dimensionDO.getHierarchyDOs();
            for (HierarchyDO hierarchyDO : arrayList2) {
                ArrayList<LevelDO> arrayList3 = hierarchyDO.getLevelDOs();
                int n = 1;
                for (LevelDO levelDO : arrayList3) {
                    levelDO.setDepth(n);
                    ++n;
                }
            }
        }
    }

    public ArrayList<DimensionDO> getDimensionDOs() {
        if (this.m_dimDOs == null) {
            this.m_dimDOs = new ArrayList();
        }
        return this.m_dimDOs;
    }

    public int getModelRowCount() {
        int n = 0;
        ArrayList<DimensionDO> arrayList = this.getDimensionDOs();
        for (DimensionDO dimensionDO : arrayList) {
            ArrayList<HierarchyDO> arrayList2 = dimensionDO.getHierarchyDOs();
            for (HierarchyDO hierarchyDO : arrayList2) {
                ArrayList<LevelDO> arrayList3 = hierarchyDO.getLevelDOs();
                for (LevelDO levelDO : arrayList3) {
                    ++n;
                }
            }
        }
        return n;
    }

    public int getValidModelRowCount() {
        int n = 0;
        ArrayList<DimensionDO> arrayList = this.getDimensionDOs();
        for (DimensionDO dimensionDO : arrayList) {
            if (!dimensionDO.getValidState()) continue;
            ArrayList<HierarchyDO> arrayList2 = dimensionDO.getHierarchyDOs();
            for (HierarchyDO hierarchyDO : arrayList2) {
                ArrayList<LevelDO> arrayList3 = hierarchyDO.getLevelDOs();
                for (LevelDO levelDO : arrayList3) {
                    ++n;
                }
            }
        }
        return n;
    }

    public LevelDO getLevelDOFromRowInTable(int n) {
        LevelDO levelDO = null;
        int n2 = 0;
        ArrayList<DimensionDO> arrayList = this.getDimensionDOs();
        for (DimensionDO dimensionDO : arrayList) {
            ArrayList<HierarchyDO> arrayList2 = dimensionDO.getHierarchyDOs();
            for (HierarchyDO hierarchyDO : arrayList2) {
                ArrayList<LevelDO> arrayList3 = hierarchyDO.getLevelDOs();
                for (LevelDO levelDO2 : arrayList3) {
                    if (n2 == n) {
                        levelDO = levelDO2;
                    }
                    ++n2;
                }
            }
        }
        return levelDO;
    }

    public void setDimensionDOs(ArrayList<DimensionDO> arrayList) {
        this.m_dimDOs = arrayList;
    }

    public DimensionDO getDimensionDOFromName(String string) {
        DimensionDO dimensionDO = null;
        for (DimensionDO dimensionDO2 : this.m_dimDOs) {
            if (!dimensionDO2.getName().equalsIgnoreCase(string)) continue;
            dimensionDO = dimensionDO2;
            break;
        }
        return dimensionDO;
    }

    public HierarchyDO getHierarchyDOFromDimHier(String string, String string2) {
        DimensionDO dimensionDO = null;
        HierarchyDO dataObject = null;
        for (DimensionDO dataObject2 : this.m_dimDOs) {
            if (!dataObject2.getName().equalsIgnoreCase(string)) continue;
            dimensionDO = dataObject2;
            break;
        }
        if (dimensionDO != null) {
            for (HierarchyDO hierarchyDO : dimensionDO.getHierarchyDOs()) {
                if (!hierarchyDO.getName().equalsIgnoreCase(string2)) continue;
                dataObject = hierarchyDO;
                break;
            }
        }
        return dataObject;
    }

    public LevelDO getLevelDOFromDimHierLevel(String string, String string2, String string3) {
        DimensionDO object = null;
        LevelDO dataObject = null;
        for (DimensionDO object2 : this.m_dimDOs) {
            if (!object2.getName().equalsIgnoreCase(string)) continue;
            object = object2;
            break;
        }
        if (object != null) {
            Object object3 = null;
            for (HierarchyDO hierarchyDO : object.getHierarchyDOs()) {
                if (!hierarchyDO.getName().equalsIgnoreCase(string2)) continue;
                object3 = hierarchyDO;
                break;
            }
            if (object3 != null) {
                for (LevelDO levelDO : ((HierarchyDO)object3).getLevelDOs()) {
                    if (!levelDO.getName().equalsIgnoreCase(string3)) continue;
                    dataObject = levelDO;
                    break;
                }
            }
        }
        return dataObject;
    }

    public boolean isDimensionNameAlreadyPresent(DimensionDO dimensionDO) {
        boolean bl = false;
        if (this.m_dimDOs == null) {
            this.m_dimDOs = new ArrayList();
        }
        for (DimensionDO dimensionDO2 : this.m_dimDOs) {
            String string = dimensionDO2.getName();
            if (string == null || !string.equalsIgnoreCase(dimensionDO.getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void addDimensionDO(DimensionDO dimensionDO) {
        if (this.m_dimDOs == null) {
            this.m_dimDOs = new ArrayList();
        }
        this.m_dimDOs.add(dimensionDO);
    }

    public void setAllDimensionListCache(List<String> list) {
        this.m_dimensionListCache = list;
    }

    public List<String> getAllDimensionListCache() {
        return this.m_dimensionListCache;
    }

    public void setLaunchedFromCache(boolean bl) {
        this.m_launchedFromCache = bl;
    }

    public boolean isLaunchedFromCache() {
        return this.m_launchedFromCache;
    }

    public void setModelChangesPending(boolean bl) {
        this.m_modelChangesPending = bl;
    }

    public boolean getModelChangesPending() {
        return this.m_modelChangesPending;
    }

    public void setImportChangesPending(boolean bl) {
        this.m_didImport = bl;
    }

    public boolean getImportChangesPending() {
        return this.m_didImport;
    }

    public void setValidateReportPending(boolean bl) {
        this.m_validateReportUpdatesPending = bl;
    }

    public boolean getValidateReportPending() {
        return this.m_validateReportUpdatesPending;
    }

    public void setLastTimeValidated(String string) {
        this.m_lastTimeValidated = string;
    }

    public String getLastTimeValidated() {
        return this.m_lastTimeValidated;
    }

    public void setReportLastTimeValidated(String string, String string2) {
        if (this.m_lastTimeValidatedMap == null) {
            this.initializeLastTimeValidatedMap();
        }
        this.m_lastTimeValidatedMap.put(string, string2);
    }

    public String getReportLastTimeValidated(String string) {
        String string2;
        if (this.m_lastTimeValidatedMap == null) {
            this.initializeLastTimeValidatedMap();
        }
        if ((string2 = this.m_lastTimeValidatedMap.get(string)) == null || string2.length() == 0) {
            string2 = "Never";
        }
        return string2;
    }

    public boolean hasValidationReportsEverBeenRun() {
        boolean bl = false;
        if (this.m_lastTimeValidatedMap != null) {
            for (String string : this.m_lastTimeValidatedMap.values()) {
                if (string == null || string.equalsIgnoreCase("Never")) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void setMessageDimensionFilter(String string) {
        this.m_messageDimensionFilter = string;
    }

    public String getMessageDimensionFilter() {
        return this.m_messageDimensionFilter;
    }

    public void setDisableReport(boolean bl) {
        this.m_disableReport = bl;
    }

    public boolean getDisableReport() {
        return this.m_disableReport;
    }

    public MessageDO getMetadataValidationMessages() {
        MessageDO messageDO = new MessageDO();
        ArrayList<DimensionDO> arrayList = this.getDimensionDOs();
        for (DimensionDO dimensionDO : arrayList) {
            if (dimensionDO.getValidState()) continue;
            for (HierarchyDO hierarchyDO : dimensionDO.getHierarchyDOs()) {
                for (LevelDO levelDO : hierarchyDO.getLevelDOs()) {
                    String string;
                    if (levelDO.getValidState() != LevelDO.ValidStates.VALID_ERROR) continue;
                    LevelMapDO levelMapDO = levelDO.getLevelMapDO();
                    StringBuffer stringBuffer = new StringBuffer();
                    if (!levelMapDO.isOwnerNameValid()) {
                        stringBuffer.append(OLAPDVArb.getString("OWNER_FOR_MAPPING_VALIDATION_ERROR_MSG"));
                        stringBuffer.append(", ");
                    }
                    if (!levelMapDO.isTableNameValid()) {
                        stringBuffer.append(OLAPDVArb.getString("TABLE_NAME_FOR_MAPPING_VALIDATION_ERROR_MSG"));
                        stringBuffer.append(", ");
                    }
                    if (!levelMapDO.isKeyColumnValid()) {
                        stringBuffer.append(OLAPDVArb.getString("KEY_COLUMN_FOR_MAPPING_VALIDATION_ERROR_MSG"));
                        stringBuffer.append(", ");
                    }
                    if (!levelMapDO.isDescColumnValid()) {
                        stringBuffer.append(OLAPDVArb.getString("DESC_COLUMN_FOR_MAPPING_VALIDATION_ERROR_MSG"));
                        stringBuffer.append(", ");
                    }
                    if (!levelMapDO.isSnowflakeColumnValid()) {
                        stringBuffer.append(OLAPDVArb.getString("SNOWFLAKE_COLUMN_FOR_MAPPING_VALIDATION_ERROR_MSG"));
                        stringBuffer.append(", ");
                    }
                    if ((string = stringBuffer.toString()) != null && string.length() > 2) {
                        string = string.substring(0, string.length() - 2);
                    }
                    messageDO.addMessage("ERROR", dimensionDO.getName(), OLAPDVArb.format("LEVEL_MAPPING_VALIDATION_ERROR_MSG", hierarchyDO.getName(), levelDO.getName(), string));
                }
            }
        }
        return messageDO;
    }
}

