/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import oracle.olapdv.OLAPDVArb;
import oracle.olapdv.app.MessageTable;
import oracle.olapdv.app.MessageTableCellEditor;
import oracle.olapdv.app.ValidateViewer;
import oracle.olapdv.olap.model.DimensionDO;
import oracle.olapdv.olap.model.HierarchyDO;
import oracle.olapdv.olap.model.LevelDO;
import oracle.olapdv.olap.model.MessageDO;
import oracle.olapdv.olap.model.ValidateModelDO;

public class ValidateMessagePanel
extends JPanel
implements ListSelectionListener {
    private DefaultTableModel m_tableModel;
    private MessageTable m_table;
    private Component m_parentComponent;
    private ValidateViewer m_validateViewer;
    private ValidateMessagePanel m_messagePanel;
    private ValidateModelDO m_validateModelDO;
    private int m_lastRow = -1;
    private int m_lastColumn = -1;
    private int m_initialRowHeight;

    public ValidateMessagePanel(Component component, ValidateViewer validateViewer, ValidateModelDO validateModelDO) {
        this.m_parentComponent = component;
        this.m_validateViewer = validateViewer;
        this.m_validateModelDO = validateModelDO;
        this.m_messagePanel = this;
        this.jbinit();
    }

    public void setModelDO(ValidateModelDO validateModelDO) {
        this.m_validateModelDO = validateModelDO;
    }

    private void jbinit() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setBackground(Color.WHITE);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        Object[][] objectArray = new Object[5][1];
        Object[] objectArray2 = this.getColumnNames();
        this.m_tableModel = new DefaultTableModel(objectArray, objectArray2);
        this.m_table = new MessageTable(this.m_tableModel);
        this.setColumnWidths();
        this.m_table.setSelectionMode(0);
        this.m_table.setBackground(Color.WHITE);
        this.m_initialRowHeight = this.m_table.getRowHeight();
        this.m_table.setRowHeight(this.m_initialRowHeight * 3);
        JScrollPane jScrollPane = new JScrollPane(this.m_table);
        jScrollPane.setBackground(Color.WHITE);
        MessageTableCellEditor messageTableCellEditor = new MessageTableCellEditor();
        this.m_table.setDefaultEditor(Object.class, messageTableCellEditor);
        messageTableCellEditor.setValidateTable(this.m_table);
        ++gridBagConstraints.gridy;
        this.add((Component)jScrollPane, gridBagConstraints);
        this.m_table.getSelectionModel().addListSelectionListener(this);
        this.m_table.getColumnModel().getSelectionModel().addListSelectionListener(this);
    }

    public JTable getJTable() {
        return this.m_table;
    }

    public void refreshMessageData(int n) {
        Object[][] objectArray = this.getMessages();
        Object[] objectArray2 = this.getColumnNames();
        this.m_tableModel = new DefaultTableModel(objectArray, objectArray2);
        this.m_table.setModel(this.m_tableModel);
        this.setColumnWidths();
        if (n == 2) {
            this.m_table.setRowHeight(4 * this.m_initialRowHeight);
        } else {
            this.m_table.setRowHeight(3 * this.m_initialRowHeight);
        }
        this.m_table.revalidate();
        this.m_table.repaint();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.m_table.getSelectedRow();
        int n2 = this.m_table.getSelectedColumn();
        boolean bl = listSelectionEvent.getValueIsAdjusting();
        if (n == this.m_lastRow && n2 == this.m_lastColumn) {
            return;
        }
        this.m_lastRow = n;
        this.m_lastColumn = n2;
        if (n < 0) {
            return;
        }
        if (n >= this.m_table.getRowCount()) {
            this.m_table.editCellAt(this.m_table.getRowCount() - 1, 2);
            return;
        }
        this.m_table.editCellAt(n, 2);
    }

    private Object[][] getMessages() {
        int n = this.m_validateViewer.getActiveReport();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        MessageDO messageDO = new MessageDO();
        ArrayList<DimensionDO> arrayList = this.m_validateModelDO.getDimensionDOs();
        for (DimensionDO dimensionDO : arrayList) {
            ArrayList<HierarchyDO> arrayList2 = dimensionDO.getHierarchyDOs();
            for (HierarchyDO hierarchyDO : arrayList2) {
                ArrayList<LevelDO> arrayList3 = hierarchyDO.getLevelDOs();
                boolean bl = true;
                for (LevelDO levelDO : arrayList3) {
                    String string = dimensionDO.getName();
                    String string2 = hierarchyDO.getName();
                    String string3 = levelDO.getName();
                    n2 = levelDO.getValidateReport("Distinct Members");
                    if (levelDO.getDepth() > 1) {
                        LevelDO levelDO2 = levelDO.getParentLevelDO();
                        n3 = levelDO2.getValidateReport("Distinct Members");
                    }
                    switch (n) {
                        case 1: {
                            if (bl) {
                                bl = false;
                                n5 = n2;
                                if (n2 == -1 || n2 == 1) break;
                                messageDO.addMessage("WARNING", string, OLAPDVArb.format("DV_0001", string3, string, string2));
                                break;
                            }
                            if (n5 != -1 && n2 != -1 && n2 < n5) {
                                if (hierarchyDO.isLevelALeaf(levelDO)) {
                                    messageDO.addMessage("WARNING", string, OLAPDVArb.format("DV_0002", string3, string, string2));
                                } else {
                                    messageDO.addMessage("WARNING", string, OLAPDVArb.format("DV_0003", string3, string, string2));
                                }
                            }
                            n5 = n2;
                            break;
                        }
                        case 2: {
                            n4 = levelDO.getValidateReport("Distinct Members And Descriptions");
                            if (n4 == n2 || n2 < 1 || n4 < 0) break;
                            messageDO.addMessage("WARNING", string, OLAPDVArb.format("DV_0004", string3, string, string2));
                            break;
                        }
                        case 3: {
                            n2 = levelDO.getValidateReport("Duplicate Members Across Levels");
                            if (n2 <= 0) break;
                            messageDO.addMessage("WARNING", string, OLAPDVArb.format("DV_0005", string3, string, string2, n2));
                            break;
                        }
                        case 4: {
                            int n6 = levelDO.getValidateReport("Rows With Null Members");
                            if (n6 <= 0) break;
                            if (hierarchyDO.isLevelALeaf(levelDO)) {
                                messageDO.addMessage("WARNING", string, OLAPDVArb.format("DV_0006", string3, string, string2));
                                break;
                            }
                            messageDO.addMessage("WARNING", string, OLAPDVArb.format("DV_0007", string3, string, string2));
                            break;
                        }
                        case 5: {
                            int n7 = levelDO.getValidateReport("Members With Null Descriptions");
                            if (n2 <= 0 || n7 <= 0) break;
                            messageDO.addMessage("WARNING", string, OLAPDVArb.format("DV_0008", string3, string, string2, n7));
                            break;
                        }
                        case 8: {
                            int n8 = levelDO.getValidateReport("Members With Multiple Parents");
                            if (n8 <= 0) break;
                            messageDO.addMessage("ERROR", string, OLAPDVArb.format("DV_0009", string3, string, string2, n8));
                            break;
                        }
                        case 6: {
                            int n9 = levelDO.getValidateReport("Members With Multiple Descriptions");
                            if (n9 <= 0) break;
                            messageDO.addMessage("WARNING", string, OLAPDVArb.format("DV_0010", string3, string, string2, n9));
                            break;
                        }
                        case 9: {
                            int n10 = levelDO.getValidateReport("Descriptions With Multiple Parent Descriptions");
                            if (n10 <= 0) break;
                            messageDO.addMessage("WARNING", string, OLAPDVArb.format("DV_0011", string3, string, string2, n10));
                            break;
                        }
                        case 7: {
                            int n11 = levelDO.getValidateReport("Descriptions With Multiple Members");
                            if (n11 <= 0) break;
                            messageDO.addMessage("WARNING", string, OLAPDVArb.format("DV_0012", string3, string, string2, n11));
                        }
                    }
                }
            }
        }
        return messageDO.getMessages();
    }

    private String[] getColumnNames() {
        String[] stringArray = new String[]{OLAPDVArb.getString("SEVERITY_HEADER"), OLAPDVArb.getString("DIMENSION_HEADER"), OLAPDVArb.getString("MESSAGE_HEADER")};
        return stringArray;
    }

    private void setColumnWidths() {
        this.m_table.getColumnModel().getColumn(0).setPreferredWidth(75);
        this.m_table.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.m_table.getColumnModel().getColumn(2).setPreferredWidth(660);
    }
}

