/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.app;

import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.ide.help.HelpSystem;
import oracle.olapdv.OLAPDVArb;
import oracle.olapdv.app.AllReportPanel;
import oracle.olapdv.app.AllReportViewer;
import oracle.olapdv.app.AutomaticModelValidation;
import oracle.olapdv.app.DataValidatePanel;
import oracle.olapdv.app.ModelPanel;
import oracle.olapdv.app.ModelViewer;
import oracle.olapdv.app.ProgressStatusDialog;
import oracle.olapdv.app.RootNodeViewer;
import oracle.olapdv.app.TreePanel;
import oracle.olapdv.app.ValidateMessagePanel;
import oracle.olapdv.app.ValidatePanel;
import oracle.olapdv.app.ValidateViewer;
import oracle.olapdv.olap.model.ValidateModelDO;
import oracle.olapdv.olap.model.ValidateTopDO;

public class TreeSelection {
    private ValidateTopDO m_validateTopDO;
    private DataValidatePanel m_dataValidatePanel;
    private ModelViewer m_modelViewer;
    private ValidateViewer m_validateViewer;
    private AllReportViewer m_allReportViewer;
    private ValidatePanel m_validatePanel;
    private RootNodeViewer m_rootNodeViewer;
    private AutomaticModelValidation automaticModelValidation;
    private String m_owner;
    private String m_modelName;

    public void setDataValidatePanel(DataValidatePanel dataValidatePanel) {
        this.m_dataValidatePanel = dataValidatePanel;
    }

    public void setModelViewer(ModelViewer modelViewer) {
        this.m_modelViewer = modelViewer;
    }

    public void setValidateViewer(ValidateViewer validateViewer) {
        this.m_validateViewer = validateViewer;
    }

    public void setAllReportViewer(AllReportViewer allReportViewer) {
        this.m_allReportViewer = allReportViewer;
    }

    public void setValidatePanel(ValidatePanel validatePanel) {
        this.m_validatePanel = validatePanel;
    }

    public void setRootNodeViewer(RootNodeViewer rootNodeViewer) {
        this.m_rootNodeViewer = rootNodeViewer;
    }

    public void refreshRootNodePanel() {
        this.m_rootNodeViewer.refreshModelInformation();
    }

    public void setRootNodeSelected() {
        this.m_rootNodeViewer.refreshModelInformation();
        this.m_dataValidatePanel.setRightComponent(this.m_rootNodeViewer);
    }

    public void setTopValidateModelDO(ValidateTopDO validateTopDO) {
        this.m_validateTopDO = validateTopDO;
    }

    public void setOwner(String string) {
        this.m_owner = string;
    }

    public void setModelName(String string) {
        this.m_modelName = string;
    }

    public void refreshTreeAfterNodeDelete(DefaultMutableTreeNode defaultMutableTreeNode) {
        String string = (String)defaultMutableTreeNode.getUserObject();
        int n = defaultMutableTreeNode.getDepth();
        if (this.m_validateTopDO.getModels().size() == 0) {
            this.m_rootNodeViewer.refreshModelInformation();
            this.m_dataValidatePanel.setRightComponent(this.m_rootNodeViewer);
        } else {
            ValidateModelDO validateModelDO = this.m_validateTopDO.getValidateModelDO(this.m_owner, this.m_modelName);
            this.m_modelViewer.refreshModelViewPanel(validateModelDO);
            this.m_validateViewer.refreshValidateViewPanels(validateModelDO);
            this.m_allReportViewer.refreshAllReportPanel(validateModelDO);
        }
    }

    public void treeNodeSelected(DefaultMutableTreeNode defaultMutableTreeNode) {
        String string = (String)defaultMutableTreeNode.getUserObject();
        int n = defaultMutableTreeNode.getDepth();
        this.resetLevelDOInValidatePanel();
        if (this.m_validateTopDO.getModels().size() == 0) {
            this.m_rootNodeViewer.refreshModelInformation();
            this.m_dataValidatePanel.setRightComponent(this.m_rootNodeViewer);
        } else if (n == 2) {
            this.m_rootNodeViewer.refreshModelInformation();
            this.m_dataValidatePanel.setRightComponent(this.m_rootNodeViewer);
        } else if (n == 1) {
            ValidateModelDO validateModelDO = this.m_validateTopDO.getValidateModelDO(this.m_owner, this.m_modelName);
            this.m_validateViewer.refreshValidateViewPanels(validateModelDO);
            this.m_allReportViewer.refreshAllReportPanel(validateModelDO);
            this.m_allReportViewer.getAllReportPanel().refreshMessageData();
            this.m_dataValidatePanel.setRightComponent(this.m_allReportViewer);
            AllReportPanel allReportPanel = this.m_allReportViewer.getAllReportPanel();
            JTable jTable = allReportPanel.getJTable();
            this.setMessageCell(jTable, 3);
        } else if (n == 0) {
            JTable jTable;
            ValidateMessagePanel validateMessagePanel;
            ValidateModelDO validateModelDO = this.m_validateTopDO.getValidateModelDO(this.m_owner, this.m_modelName);
            this.m_validateViewer.refreshValidateViewPanels(validateModelDO);
            this.m_allReportViewer.refreshAllReportPanel(validateModelDO);
            if (string.equalsIgnoreCase(TreePanel.METADATA_AND_MAPPING_REPORT)) {
                this.m_modelViewer.refreshModelViewPanel(validateModelDO);
                this.m_dataValidatePanel.setRightComponent(this.m_modelViewer);
            } else {
                this.m_dataValidatePanel.setRightComponent(this.m_validateViewer);
                this.m_validatePanel.disableDrillToDetailButton();
            }
            if (string.equalsIgnoreCase(TreePanel.MEMBER_COUNT_REPORT)) {
                this.m_validatePanel.setActiveReport(1);
                this.m_validateViewer.setActiveReport(1);
                this.m_validatePanel.setReportTitle(OLAPDVArb.get("DISTINCT_MEMBERS_HEADER"));
                this.updateLastTimeValidatedDisplay(validateModelDO.getReportLastTimeValidated("Distinct Members"));
                HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_validatePanel, "olapdv_distinct_mem_rpt");
                this.m_validatePanel.refreshTableData();
                this.m_validatePanel.updateValidateButtonState();
                this.m_validateViewer.refreshMessages(validateModelDO);
                validateMessagePanel = this.m_validateViewer.getValidateMessagePanel();
                jTable = validateMessagePanel.getJTable();
                this.setMessageCell(jTable, 2);
            }
            if (string.equalsIgnoreCase(TreePanel.DISTINCT_DESCRIPTION_REPORT)) {
                this.m_validatePanel.setActiveReport(2);
                this.m_validateViewer.setActiveReport(2);
                this.m_validatePanel.setReportTitle(OLAPDVArb.get("DISTINCT_DESCRIPTION_REPORT"));
                this.updateLastTimeValidatedDisplay(validateModelDO.getReportLastTimeValidated("Distinct Members And Descriptions"));
                HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_validatePanel, "olapdv_distinct_mem_descr_rpt");
                this.m_validatePanel.refreshTableData();
                this.m_validatePanel.updateValidateButtonState();
                this.m_validateViewer.refreshMessages(validateModelDO);
                validateMessagePanel = this.m_validateViewer.getValidateMessagePanel();
                jTable = validateMessagePanel.getJTable();
                this.setMessageCell(jTable, 2);
            }
            if (string.equalsIgnoreCase(TreePanel.NONUNIQUE_MEMBERS_ACROSS_LEVEL)) {
                this.m_validatePanel.setActiveReport(3);
                this.m_validateViewer.setActiveReport(3);
                this.m_validatePanel.setReportTitle(OLAPDVArb.get("DUPLICATE_MEMBERS_ACROSS_LEVELS_HEADER"));
                this.updateLastTimeValidatedDisplay(validateModelDO.getReportLastTimeValidated("Duplicate Members Across Levels"));
                HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_validatePanel, "olapdv_dup_mem_rpt");
                this.m_validatePanel.refreshTableData();
                this.m_validatePanel.updateValidateButtonState();
                this.m_validateViewer.refreshMessages(validateModelDO);
                validateMessagePanel = this.m_validateViewer.getValidateMessagePanel();
                jTable = validateMessagePanel.getJTable();
                this.setMessageCell(jTable, 2);
            }
            if (string.equalsIgnoreCase(TreePanel.NULL_MEMBER_REPORT)) {
                this.m_validatePanel.setActiveReport(4);
                this.m_validateViewer.setActiveReport(4);
                this.m_validatePanel.setReportTitle(OLAPDVArb.get("NULL_MEMBER_REPORT"));
                this.updateLastTimeValidatedDisplay(validateModelDO.getReportLastTimeValidated("Rows With Null Members"));
                HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_validatePanel, "olapdv_rows_null_mem_rpt");
                this.m_validatePanel.refreshTableData();
                this.m_validatePanel.updateValidateButtonState();
                this.m_validateViewer.refreshMessages(validateModelDO);
                validateMessagePanel = this.m_validateViewer.getValidateMessagePanel();
                jTable = validateMessagePanel.getJTable();
                this.setMessageCell(jTable, 2);
            }
            if (string.equalsIgnoreCase(TreePanel.NULL_DESCRIPTION_REPORT)) {
                this.m_validatePanel.setActiveReport(5);
                this.m_validateViewer.setActiveReport(5);
                this.m_validatePanel.setReportTitle(OLAPDVArb.get("NULL_DESCRIPTION_REPORT"));
                this.updateLastTimeValidatedDisplay(validateModelDO.getReportLastTimeValidated("Members With Null Descriptions"));
                HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_validatePanel, "olapdv_mem_null_descr_rpt");
                this.m_validatePanel.refreshTableData();
                this.m_validatePanel.updateValidateButtonState();
                this.m_validateViewer.refreshMessages(validateModelDO);
                validateMessagePanel = this.m_validateViewer.getValidateMessagePanel();
                jTable = validateMessagePanel.getJTable();
                this.setMessageCell(jTable, 2);
            }
            if (string.equalsIgnoreCase(TreePanel.MEMBERS_MULTIPLE_DESCRIPTION_REPORT)) {
                this.m_validatePanel.setActiveReport(6);
                this.m_validateViewer.setActiveReport(6);
                this.m_validatePanel.setReportTitle(OLAPDVArb.get("MEMBERS_MULTIPLE_DESCRIPTION_REPORT"));
                this.updateLastTimeValidatedDisplay(validateModelDO.getReportLastTimeValidated("Members With Multiple Descriptions"));
                HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_validatePanel, "olapdv_mem_mult_descr_rpt");
                this.m_validatePanel.refreshTableData();
                this.m_validatePanel.updateValidateButtonState();
                this.m_validateViewer.refreshMessages(validateModelDO);
                validateMessagePanel = this.m_validateViewer.getValidateMessagePanel();
                jTable = validateMessagePanel.getJTable();
                this.setMessageCell(jTable, 2);
            }
            if (string.equalsIgnoreCase(TreePanel.DESCRIPTIONS_WITH_MULTIPLE_MEMBER_REPORT)) {
                this.m_validatePanel.setActiveReport(7);
                this.m_validateViewer.setActiveReport(7);
                this.m_validatePanel.setReportTitle(OLAPDVArb.get("DESCRIPTIONS_WITH_MULTIPLE_MEMBER_REPORT"));
                this.updateLastTimeValidatedDisplay(validateModelDO.getReportLastTimeValidated("Descriptions With Multiple Members"));
                HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_validatePanel, "olapdv_descr_mult_mem_rpt");
                this.m_validatePanel.refreshTableData();
                this.m_validatePanel.updateValidateButtonState();
                this.m_validateViewer.refreshMessages(validateModelDO);
                validateMessagePanel = this.m_validateViewer.getValidateMessagePanel();
                jTable = validateMessagePanel.getJTable();
                this.setMessageCell(jTable, 2);
            }
            if (string.equalsIgnoreCase(TreePanel.MEMBERS_WITH_MULTIPLE_PARENTS_REPORT)) {
                this.m_validatePanel.setActiveReport(8);
                this.m_validateViewer.setActiveReport(8);
                this.m_validatePanel.setReportTitle(OLAPDVArb.get("MEMBERS_WITH_MULTIPLE_PARENTS_REPORT"));
                this.updateLastTimeValidatedDisplay(validateModelDO.getReportLastTimeValidated("Members With Multiple Parents"));
                HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_validatePanel, "olapdv_mem_mult_parent_rpt");
                this.m_validatePanel.refreshTableData();
                this.m_validatePanel.updateValidateButtonState();
                this.m_validateViewer.refreshMessages(validateModelDO);
                validateMessagePanel = this.m_validateViewer.getValidateMessagePanel();
                jTable = validateMessagePanel.getJTable();
                this.setMessageCell(jTable, 2);
            }
            if (string.equalsIgnoreCase(TreePanel.DESCRIPTIONS_WITH_PARENTS_WITH_MULTIPLE_DESCRIPTION_REPORT)) {
                this.m_validatePanel.setActiveReport(9);
                this.m_validateViewer.setActiveReport(9);
                this.m_validatePanel.setReportTitle(OLAPDVArb.get("DESCRIPTIONS_WITH_PARENTS_WITH_MULTIPLE_DESCRIPTION_REPORT"));
                this.updateLastTimeValidatedDisplay(validateModelDO.getReportLastTimeValidated("Descriptions With Multiple Parent Descriptions"));
                HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_validatePanel, "olapdv_descr_mult_parent_dscr_rpt");
                this.m_validatePanel.refreshTableData();
                this.m_validatePanel.updateValidateButtonState();
                this.m_validateViewer.refreshMessages(validateModelDO);
                validateMessagePanel = this.m_validateViewer.getValidateMessagePanel();
                jTable = validateMessagePanel.getJTable();
                this.setMessageCell(jTable, 2);
            }
            this.m_validatePanel.setFirstRowFocused();
        }
    }

    private void setMessageCell(JTable jTable, int n) {
        final JTable jTable2 = jTable;
        final int n2 = n;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int n = jTable2.getRowCount();
                if (n > 0) {
                    jTable2.editCellAt(0, n2);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void runValidationOnAllReports(boolean bl, String string, int[] nArray) {
        boolean bl2 = this.m_validatePanel.runValidationOnAllReports(string, bl, nArray);
        if (bl2) {
            this.m_allReportViewer.getAllReportPanel().refreshMessageData();
        }
    }

    public void resetDividerLocation() {
        this.m_dataValidatePanel.resetDividerLocation();
    }

    public void setReportTitle(String string) {
        this.m_validateViewer.getValidatePanel().setReportTitle(string);
    }

    public void updateLastTimeValidatedDisplay(String string) {
        this.m_validateViewer.getValidatePanel().showLastTimeRun(string);
    }

    public void updateValidateButtonState() {
        this.m_validateViewer.getValidatePanel().updateValidateButtonState();
    }

    public void resetLevelDOInValidatePanel() {
        this.m_validateViewer.getValidatePanel().resetLevelDO();
    }

    public void maximizeDialog() {
        this.m_modelViewer.maximizeDialog();
    }

    public Thread runAutomaticModelValidation(ValidateModelDO validateModelDO, ProgressStatusDialog progressStatusDialog) {
        ModelPanel modelPanel = this.m_modelViewer.getModelPanel();
        modelPanel.setModelDO(validateModelDO);
        this.automaticModelValidation = new AutomaticModelValidation(modelPanel, progressStatusDialog);
        this.automaticModelValidation.start();
        return this.automaticModelValidation;
    }
}

