/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.app;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JFrame;
import oracle.olapdv.app.LaunchStatus;
import oracle.olapdv.app.ProgressStatusPanel;
import oracle.olapdv.app.SwingWorker;
import oracle.olapdv.app.ValidateInterruptObserver;

public class ProgressStatusDialog
extends JDialog {
    private ProgressStatusPanel m_progressStatusPanel;
    private String m_summaryMessage;
    private SwingWorker m_worker = null;
    private ArrayList<ValidateInterruptObserver> m_observers = new ArrayList();
    private boolean m_supportCancel;
    private boolean m_isIndeterminate = false;

    public ProgressStatusDialog(JFrame jFrame, String string, String string2, boolean bl) {
        super(jFrame, string, true);
        this.m_summaryMessage = string2;
        this.m_supportCancel = bl;
    }

    public ProgressStatusDialog(JDialog jDialog, String string, String string2, boolean bl) {
        super(jDialog, string, true);
        this.m_summaryMessage = string2;
        this.m_supportCancel = bl;
    }

    public void initializeDialogPanel() {
        this.m_progressStatusPanel = new ProgressStatusPanel(this, this.m_summaryMessage, this.m_supportCancel);
        this.setContentPane(this.m_progressStatusPanel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                LaunchStatus.setInterrupted(true);
                ProgressStatusDialog.this.cancelWorkerThread();
                ProgressStatusDialog.this.clearObservers();
            }
        });
    }

    public ProgressStatusPanel getProgressStatusPanel() {
        return this.m_progressStatusPanel;
    }

    public void addObserver(ValidateInterruptObserver validateInterruptObserver) {
        if (!this.m_observers.contains(validateInterruptObserver)) {
            this.m_observers.add(validateInterruptObserver);
        }
    }

    public void clearObservers() {
        if (this.m_observers != null) {
            this.m_observers.clear();
            this.m_observers = null;
        }
    }

    public void setWorkerThread(SwingWorker swingWorker) {
        this.m_worker = swingWorker;
    }

    public void cancelWorkerThread() {
        for (ValidateInterruptObserver validateInterruptObserver : this.m_observers) {
            validateInterruptObserver.setInterrupted();
        }
    }

    public void setIsIndeterminateToTrue() {
        this.m_isIndeterminate = true;
    }

    public boolean getIsIndeterminate() {
        return this.m_isIndeterminate;
    }
}

