/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.json.objects;

import java.util.Map;
import oracle.dbtools.json.objects.JSONObjectBuilder;
import oracle.dbtools.json.objects.JSONObjectsProvider;
import oracle.dbtools.plugin.api.json.objects.JSONNode;
import oracle.dbtools.plugin.api.json.objects.JSONObject;

class JSONObjectImpl
implements JSONObject {
    private final transient JSONObjectsProvider json;
    private final Map<String, Object> properties;

    JSONObjectImpl(JSONObjectsProvider json, Map<String, Object> properties) {
        this.json = json;
        this.properties = properties;
    }

    public Object get(String propertyName) {
        return this.properties.get(propertyName);
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public JSONObject.Builder modify() {
        JSONObjectBuilder builder = new JSONObjectBuilder(this.json);
        builder.add(this);
        return builder;
    }

    public Iterable<String> propertyNames() {
        return this.properties.keySet();
    }

    public int size() {
        return this.properties.size();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.json.write((Appendable)builder, (JSONNode)this);
        return builder.toString();
    }

    public JSONNode.Type type() {
        return JSONNode.Type.OBJECT;
    }
}

