/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.json.objects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.dbtools.json.objects.JSONArrayImpl;
import oracle.dbtools.json.objects.JSONObjectsProvider;
import oracle.dbtools.plugin.api.json.objects.JSONArray;
import oracle.dbtools.plugin.api.json.objects.JSONNode;

class JSONArrayBuilder
implements JSONArray.Builder {
    private final List<Object> values = new ArrayList<Object>();
    private final transient JSONObjectsProvider json;

    JSONArrayBuilder(JSONObjectsProvider json) {
        this.json = json;
    }

    public JSONArrayBuilder add(Boolean value) {
        return this._add(value);
    }

    public JSONArrayBuilder add(CharSequence value) {
        return this._add(value);
    }

    public JSONArrayBuilder add(JSONNode value) {
        return this._add(value);
    }

    public JSONArrayBuilder add(Number value) {
        return this._add(value);
    }

    public JSONArrayBuilder add(Object value) throws IllegalArgumentException {
        if (value == null) {
            return this.addNull();
        }
        if (this.json.isValidType(value)) {
            return this._add(value);
        }
        throw new IllegalArgumentException();
    }

    public JSONArrayBuilder addAll(JSONArray existing) {
        for (Object value : existing.values()) {
            this._add(value);
        }
        return this;
    }

    public JSONArrayBuilder addNull() {
        return this._add(null);
    }

    public JSONArray build() {
        return new JSONArrayImpl(this.json, Collections.unmodifiableList(this.values));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JSONArrayBuilder [values=");
        builder.append(this.values);
        builder.append("]");
        return builder.toString();
    }

    private JSONArrayBuilder _add(Object value) {
        this.values.add(value);
        return this;
    }
}

