/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.json.marshal;

import java.util.EmptyStackException;
import java.util.Map;
import java.util.Stack;
import oracle.dbtools.common.aliasing.AliasingGenerator;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.marshal.DataValueUnmarshalHandler;
import oracle.dbtools.raptor.datatypes.oracle.sql.INTERVALDS;
import oracle.dbtools.raptor.datatypes.oracle.sql.INTERVALYM;

public class JSONDataValueUnmarshalHandler
extends DataValueUnmarshalHandler {
    private Stack<Map<String, String>> aliasings = new Stack();

    public JSONDataValueUnmarshalHandler(DataType datatype, String name) {
        super(datatype, name);
    }

    public JSONDataValueUnmarshalHandler(DataType datatype) {
        this(datatype, null);
    }

    protected DataType customPopDataType() {
        DataType datatype = super.customPopDataType();
        try {
            this.aliasings.pop();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        return datatype;
    }

    protected void customPushDataType(DataType datatype) {
        super.customPushDataType(datatype);
        this.aliasings.push((Map<String, String>)AliasingGenerator.ALIASINGGENERATOR.generateNameAliasings(AliasingGenerator.ALIASING2NAME, datatype.getComponentNames()));
    }

    protected NamedValue<DataType> lookupComponentType(DataType datatype, String focusName) {
        String name;
        try {
            name = AliasingGenerator.getName(this.aliasings.peek(), (String)focusName);
        }
        catch (EmptyStackException e) {
            name = focusName;
        }
        if (name != null) {
            NamedValue componentType;
            if (datatype instanceof INTERVALYM) {
                NamedValue componentType2 = ((INTERVALYM)datatype).getComponentType(name);
                if (componentType2 != null) {
                    return componentType2;
                }
            } else if (datatype instanceof INTERVALDS && (componentType = ((INTERVALDS)datatype).getComponentType(name)) != null) {
                return componentType;
            }
        }
        return super.lookupComponentType(datatype, name);
    }
}

