/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.json.marshal;

import java.io.InputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.CharBuffer;
import java.util.Map;
import java.util.Stack;
import oracle.dbtools.common.aliasing.AliasingGenerator;
import oracle.dbtools.json.JSONReaderImpl;
import oracle.dbtools.plugin.api.json.JSONToken;
import oracle.dbtools.plugin.api.json.JSONWriter;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.StructureType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.marshal.DataValueMarshalHandler;
import oracle.dbtools.raptor.datatypes.oracle.plsql.BOOLEAN;
import oracle.dbtools.raptor.datatypes.oracle.sql.INTERVALDS;
import oracle.dbtools.raptor.datatypes.oracle.sql.INTERVALYM;
import oracle.dbtools.raptor.datatypes.oracle.sql.NumericDatum;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.STRUCT;

public class JSONDataValueMarshalHandler
implements DataValueMarshalHandler {
    private Stack<Map<String, String>> aliasingStack;
    private final JSONWriter json;

    public JSONDataValueMarshalHandler(JSONWriter json) {
        this.json = json;
        this.aliasingStack = new Stack();
    }

    public void marshal(DataValue value, String name) {
        String propName;
        String alias;
        if (name != null && (alias = this.getAlias(propName = this.filterName(name))) != null) {
            this.json.propertyName(alias);
        }
        if (!this.customMarshal(value, name)) {
            value.marshal((DataValueMarshalHandler)this, name);
        }
    }

    public final void marshal(DataValue value) {
        value.marshal((DataValueMarshalHandler)this);
    }

    public StringType getStringType() {
        return StringType.REST;
    }

    protected String filterName(String name) {
        return name;
    }

    public void startDataValue(DataType datatype, String name, boolean isNull, Map<String, Object> propertyMap) {
        if (!isNull) {
            switch (this.getStructureType(datatype)) {
                case TABLE: {
                    this.json.startArray();
                    break;
                }
                case RECORD: {
                    this.json.startObject();
                }
            }
        } else {
            this.json.nullValue();
        }
        this.aliasingStack.push((Map<String, String>)AliasingGenerator.ALIASINGGENERATOR.generateNameAliasings(AliasingGenerator.NAME2ALIASING, datatype.getComponentNames()));
    }

    public void startDataValue(DataType datatype, String name, boolean isNull) {
        this.startDataValue(datatype, name, isNull, null);
    }

    public void bodyDataValue(DataType datatype, String name, String text) {
        if (datatype instanceof NumericDatum) {
            this.json.value((Number)new BigDecimal(text));
        } else if (datatype instanceof BOOLEAN) {
            this.json.value(Boolean.valueOf(text));
        } else {
            this.json.value((CharSequence)text);
        }
    }

    public void bodyDataValue(DataType datatype, String name, Readable text) {
        this.json.value(text);
    }

    public void bodyDataValue(DataType datatype, String name, InputStream bytes) {
    }

    @Deprecated
    public void bodyDataValue(DataType datatype, String name, char[] ch, int start, int length) {
        this.bodyDataValue(datatype, name, CharBuffer.wrap(ch, start, length));
    }

    public void endDataValue(DataType datatype, String name, boolean isNull) {
        if (!isNull) {
            switch (this.getStructureType(datatype)) {
                case TABLE: {
                    this.json.endArray();
                    break;
                }
                case RECORD: {
                    this.json.endObject();
                }
            }
        }
        this.aliasingStack.pop();
    }

    private boolean customMarshal(DataValue value, String name) {
        try {
            DataType datatype;
            if (value != null && !value.isNull() && (datatype = value.getDataType()).getStructureType() == StructureType.RECORD) {
                TypeMetadata metadata = datatype.getTypeMetadata();
                String type_owner = metadata.get_type_owner();
                String type_name = metadata.get_type_name();
                if ("MDSYS".equals(type_owner) && "SDO_GEOMETRY".equals(type_name)) {
                    STRUCT struct = (STRUCT)value.getTypedValue(ValueType.DATUM);
                    JGeometry geometry = JGeometry.load((STRUCT)struct);
                    String snippet = geometry.toGeoJson();
                    JSONReaderImpl jr = new JSONReaderImpl(new StringReader(snippet));
                    while (jr.hasNext()) {
                        JSONToken token = jr.next();
                        this.json.append(token);
                    }
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public StructureType getStructureType(DataType datatype) {
        if (datatype != null) {
            if (datatype instanceof INTERVALDS || datatype instanceof INTERVALYM) {
                return StructureType.RECORD;
            }
            return datatype.getStructureType();
        }
        return null;
    }

    private String getAlias(String name) {
        Map<String, String> aliasings = this.aliasingStack.peek();
        return AliasingGenerator.getAlias(aliasings, (String)name);
    }
}

