/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.quickdiff;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.Document;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.quickdiff.QuickDiffMargin;
import oracle.ide.quickdiff.res.QuickDiffArb;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.infotip.InfoTipHover;
import oracle.javatools.ui.infotip.InfoTipOrientation;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.BasicTemplate;
import oracle.javatools.ui.infotip.templates.Template;
import oracle.javatools.ui.plaf.IconicButtonUI;

final class QuickDiffPopup {
    private final QuickDiffMargin _margin;
    private final BasicEditorPane _editorPane;
    private InfoTipHover _hover;

    QuickDiffPopup(QuickDiffMargin margin, BasicEditorPane editorPane) {
        this._margin = margin;
        this._editorPane = editorPane;
    }

    void show(Rectangle location, String topText, String bottomText, String labelText, Color color) {
        if (this._hover != null) {
            return;
        }
        JPanel content = this.createContent(this._editorPane, topText, bottomText, labelText, color);
        this._hover = new InfoTipHover((Template)new BasicTemplate((JComponent)content), InfoTipStyles.CODE, (JComponent)this._margin, location, HoverFlavor.getFlavor((String)"info"));
        this._hover.setOrientation(InfoTipOrientation.RIGHT_LEFT);
        this._hover.showHover();
        this._hover.ensureVisible();
    }

    void hide() {
        if (this._hover != null) {
            this._hover.hideHover();
        }
        this._hover = null;
    }

    private JPanel createContent(BasicEditorPane editorPane, String topText, String bottomText, String labelText, Color color) {
        JPanel content = new JPanel();
        JToolBar toolbar = new JToolBar();
        JButton prevButton = new JButton(OracleIcons.getIcon((String)"previous.png"));
        JButton nextButton = new JButton(OracleIcons.getIcon((String)"next.png"));
        JButton revertButton = new JButton(OracleIcons.getIcon((String)"undo.png"));
        JButton copyButton = new JButton(OracleIcons.getIcon((String)"patch.png"));
        JLabel label = new JLabel(labelText);
        prevButton.setEnabled(this._margin.hasNextDifference(false));
        nextButton.setEnabled(this._margin.hasNextDifference(true));
        prevButton.addActionListener(e -> this._margin.moveToNextDifference(false));
        nextButton.addActionListener(e -> this._margin.moveToNextDifference(true));
        revertButton.addActionListener(e -> this._margin.revertCurrentDifference());
        copyButton.addActionListener(e -> this._margin.copyCurrentDifference());
        prevButton.setToolTipText(QuickDiffArb.getString(8));
        nextButton.setToolTipText(QuickDiffArb.getString(7));
        revertButton.setToolTipText(QuickDiffArb.getString(9));
        copyButton.setToolTipText(QuickDiffArb.getString(10));
        IconicButtonUI.install((AbstractButton)prevButton);
        IconicButtonUI.install((AbstractButton)nextButton);
        IconicButtonUI.install((AbstractButton)revertButton);
        IconicButtonUI.install((AbstractButton)copyButton);
        toolbar.setBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, UIManager.getColor("SplitPane.darkShadow")));
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 4));
        label.setFont(InfoTipStyles.DEFAULT.getItemTitleFont());
        toolbar.add(prevButton);
        toolbar.add(nextButton);
        toolbar.addSeparator();
        toolbar.add(revertButton);
        toolbar.addSeparator();
        toolbar.add(copyButton);
        toolbar.addSeparator();
        toolbar.add(label);
        content.setLayout(new BorderLayout());
        content.add((Component)toolbar, "North");
        content.setOpaque(false);
        if (bottomText == null) {
            JComponent textComponent = this.createTextComponent(topText, color);
            textComponent.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, UIManager.getColor("SplitPane.darkShadow")));
            content.add((Component)textComponent, "Center");
        } else {
            JPanel p = new JPanel(new BorderLayout(2, 4));
            p.setOpaque(false);
            JComponent upperTextComponent = this.createTextComponent(topText, color);
            JComponent lowerTextComp = this.createTextComponent(bottomText, color);
            upperTextComponent.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, UIManager.getColor("SplitPane.darkShadow")));
            lowerTextComp.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, UIManager.getColor("SplitPane.darkShadow")));
            p.add((Component)upperTextComponent, "North");
            p.add((Component)lowerTextComp, "South");
            content.add((Component)p, "Center");
        }
        return content;
    }

    private JComponent createTextComponent(String text, Color color) {
        BasicDocument document = (BasicDocument)this._editorPane.getDocument();
        LanguageSupport support = document.getLanguageSupport();
        LanguageSupport popupSupport = LanguageModule.createSupportForFileType(support.getClass());
        BasicDocument popupDocument = new BasicDocument();
        popupDocument.setLanguageSupport(popupSupport);
        BasicEditorPane popupEditorPane = new BasicEditorPane();
        popupEditorPane.setDocument((Document)popupDocument);
        popupEditorPane.setBorder(BorderFactory.createEmptyBorder());
        popupEditorPane.setOpaque(false);
        popupEditorPane.setText(text);
        popupEditorPane.setEditable(false);
        JScrollPane popupScrollPane = new JScrollPane((Component)popupEditorPane);
        popupScrollPane.setBackground(color);
        popupScrollPane.setBorder(BorderFactory.createEmptyBorder());
        Insets editorInsets = this._editorPane.getInsets();
        Border innerBorder = BorderFactory.createEmptyBorder(0, editorInsets.left, 0, editorInsets.right);
        popupScrollPane.setViewportBorder(innerBorder);
        popupScrollPane.getViewport().setOpaque(false);
        return popupScrollPane;
    }
}

