/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import java.util.concurrent.atomic.AtomicLong;

public class NodeSequence {
    private AtomicLong lastAllocatedLocalNodeId = null;
    private AtomicLong lastAllocatedReplicatedNodeId = null;
    private AtomicLong lastAllocatedTransientNodeId = null;

    void initTransientNodeId() {
        this.lastAllocatedTransientNodeId = new AtomicLong(Long.MAX_VALUE);
    }

    void initRealNodeId() {
        this.lastAllocatedLocalNodeId = new AtomicLong(0L);
        this.lastAllocatedReplicatedNodeId = new AtomicLong(0L);
    }

    public long getLastLocalNodeId() {
        return this.lastAllocatedLocalNodeId.get();
    }

    public long getLastReplicatedNodeId() {
        return this.lastAllocatedReplicatedNodeId.get();
    }

    public long getNextLocalNodeId() {
        return this.lastAllocatedLocalNodeId.incrementAndGet();
    }

    public long getNextReplicatedNodeId() {
        return this.lastAllocatedReplicatedNodeId.decrementAndGet();
    }

    public long getNextTransientNodeId() {
        assert (this.noOverlap()) : "transient=" + this.lastAllocatedTransientNodeId.get();
        return this.lastAllocatedTransientNodeId.decrementAndGet();
    }

    private boolean noOverlap() {
        if (this.lastAllocatedLocalNodeId != null) {
            return this.lastAllocatedTransientNodeId.get() - 1L > this.lastAllocatedLocalNodeId.get();
        }
        return true;
    }

    public void setLastNodeId(long lastReplicatedNodeId, long lastLocalNodeId) {
        this.lastAllocatedReplicatedNodeId.set(lastReplicatedNodeId);
        this.lastAllocatedLocalNodeId.set(lastLocalNodeId);
    }

    public void updateFromReplay(long replayNodeId) {
        boolean ok;
        long currentVal;
        assert (replayNodeId < 0L) : "replay node id is unexpectedly positive " + replayNodeId;
        while (replayNodeId < (currentVal = this.lastAllocatedReplicatedNodeId.get()) && !(ok = this.lastAllocatedReplicatedNodeId.weakCompareAndSet(currentVal, replayNodeId))) {
        }
    }
}

