/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.share;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;

public class UnmodifiableArrayList<T>
extends AbstractList<T> {
    private int _hashCode = -1;
    private final T[] _array;

    public UnmodifiableArrayList(T ... array) {
        if (array == null) {
            throw new IllegalArgumentException("null array");
        }
        this._array = array;
    }

    @Override
    public T get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new NoSuchElementException();
        }
        return this._array[index];
    }

    @Override
    public int size() {
        return this._array.length;
    }

    @Override
    public int hashCode() {
        if (this._hashCode == -1) {
            int hashCode = 1;
            for (T obj : this._array) {
                hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
            }
            this._hashCode = hashCode;
        }
        return this._hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        if (o.getClass() == UnmodifiableArrayList.class) {
            if (this.hashCode() != o.hashCode()) {
                return false;
            }
            return Arrays.equals(this._array, ((UnmodifiableArrayList)o)._array);
        }
        return super.equals(o);
    }
}

