/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.view;

import java.util.HashMap;
import java.util.Map;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.view.FilteredView;
import org.w3c.dom.Node;

public abstract class AbstractSubtreeFilteredView
extends FilteredView {
    private Node _root = null;
    private final Map _cache = new HashMap();
    private static final Short _ACCEPT = new Short(1);
    private static final Short _SKIP = new Short(3);
    private static final Short _REJECT = new Short(2);

    protected abstract Node updateRootNode(XmlModelEvent var1, Node var2);

    protected short acceptNodeInSubtree(Node modelNode) {
        return 1;
    }

    @Override
    protected XmlModelEvent transformModelEventHook(XmlModelEvent modelChangeEvent) {
        if (modelChangeEvent.isDomTreeChanged()) {
            Node oldRoot = this._root;
            this._root = this.updateRootNode(modelChangeEvent, oldRoot);
            if (oldRoot != this._root || modelChangeEvent.isDomStructureChanged()) {
                this._clearCache();
            }
        }
        return super.transformModelEventHook(modelChangeEvent);
    }

    @Override
    protected final short acceptNode(Node modelNode) {
        if (DomUtils.isDocument((Node)modelNode)) {
            return 1;
        }
        if (this._root == null) {
            return 2;
        }
        short initialRet = this._acceptNodeUnderSubtree(modelNode);
        if (initialRet != 1 || this._isRootOrDocNode(modelNode)) {
            return initialRet;
        }
        return this.acceptNodeInSubtree(modelNode);
    }

    @Override
    protected void baseModelAttached() {
        super.baseModelAttached();
        this._root = this.updateRootNode(null, this._root);
        this._clearCache();
    }

    private boolean _isRootOrDocNode(Node node) {
        return node == this._root || node.getNodeType() == 9;
    }

    private short _acceptNodeUnderSubtree(Node node) {
        Short ret;
        Short cached = (Short)this._cache.get(node);
        if (cached != null) {
            ret = cached;
        } else {
            ret = this._isRootOrDocNode(node) ? _ACCEPT : (DomUtils.isDescendant((Node)this._root, (Node)node) ? _SKIP : (DomUtils.isDescendant((Node)node, (Node)this._root) ? _ACCEPT : _SKIP));
            this._cache.put(node, ret);
        }
        return ret;
    }

    private void _clearCache() {
        this._cache.clear();
    }
}

