/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.metadata;

import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.metadata.ContextualPropertyEditor;
import oracle.bali.xml.util.ContextualAttributeValueItemProvider;
import oracle.bali.xml.util.XmlModelUtils;
import org.w3c.dom.Node;

public final class PropertyEditorContext
implements Cloneable {
    private XmlContext _xmlContext;
    private XmlKey _key;
    private Node _node;
    private Node _ownerNode;
    private XmlKey _ownerKey;
    private Node _nearestAncestor;
    private Node _targetNode;
    private TreeTraversal _ownerTraversal;
    private static final PropertyEditorContext _PRIVATE_INSTANCE = new PropertyEditorContext();

    public static PropertyEditorContext create(XmlContext context, XmlKey key, Node node, Node ownerNode, XmlKey ownerKey, Node nearestAncestor, Node targetNode) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        if (nearestAncestor == null) {
            throw new IllegalArgumentException("nearestAncestor cannot be null");
        }
        if (targetNode == null) {
            throw new IllegalArgumentException("targetNode cannot be null");
        }
        PropertyEditorContext pec = new PropertyEditorContext();
        pec._reinit(context, key, node, ownerNode, ownerKey, nearestAncestor, targetNode);
        return pec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setContext(Object editor, XmlContext context, XmlKey key, Node node, Node ownerNode) {
        if (ownerNode == null) {
            throw new IllegalArgumentException("ownerNode is null");
        }
        XmlKey ownerKey = null;
        context.getModel().acquireReadLock();
        try {
            if (context.getModel().isInModelDocumentHierarchy(ownerNode)) {
                ownerKey = context.getModel().getNodeXmlKey(ownerNode);
            }
        }
        finally {
            context.getModel().releaseReadLock();
        }
        if (context == null && key == null && node == null) {
            PropertyEditorContext.clearContext(editor);
        } else {
            _PRIVATE_INSTANCE._reinit(context, key, node, ownerNode, ownerKey, ownerNode, ownerNode);
            try {
                PropertyEditorContext.setContext(editor, _PRIVATE_INSTANCE);
            }
            finally {
                _PRIVATE_INSTANCE._clear();
            }
        }
    }

    public static void setContext(Object editor, PropertyEditorContext context) {
        if (context == null) {
            PropertyEditorContext.clearContext(editor);
        } else if (editor instanceof ContextualPropertyEditor) {
            ((ContextualPropertyEditor)editor).setContext(context);
        } else if (editor instanceof oracle.bali.xml.util.ContextualPropertyEditor) {
            oracle.bali.xml.util.ContextualPropertyEditor cpe = (oracle.bali.xml.util.ContextualPropertyEditor)editor;
            cpe.setContext(context.getXmlContext(), context.getKey(), context.getNode(), context.getOwnerNode());
        }
    }

    public static void setContextOnContextualAttributeValueItemProvider(ContextualAttributeValueItemProvider cavip, PropertyEditorContext pec) {
        if (pec == null) {
            PropertyEditorContext.clearContextOnContextualAttributeValueItemProvider(cavip);
        } else {
            cavip.setContext(pec);
        }
    }

    public static void clearContext(Object editor) {
        if (editor instanceof ContextualPropertyEditor) {
            ((ContextualPropertyEditor)editor).clearContext();
        } else if (editor instanceof oracle.bali.xml.util.ContextualPropertyEditor) {
            oracle.bali.xml.util.ContextualPropertyEditor cpe = (oracle.bali.xml.util.ContextualPropertyEditor)editor;
            cpe.setContext(null, null, null, null);
        }
    }

    public static void clearContextOnContextualAttributeValueItemProvider(ContextualAttributeValueItemProvider cavip) {
        cavip.clearContext();
    }

    public PropertyEditorContext clone() {
        try {
            return (PropertyEditorContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public XmlContext getXmlContext() {
        return this._xmlContext;
    }

    public XmlKey getKey() {
        return this._key;
    }

    public Node getNode() {
        return this._node;
    }

    public Node getOwnerNode() {
        return this._ownerNode;
    }

    public XmlKey getOwnerKey() {
        return this._ownerKey;
    }

    public Node getNearestAncestor() {
        return this._nearestAncestor;
    }

    public Node getTargetNode() {
        return this._targetNode;
    }

    public TreeTraversal getOwnerTreeTraversal() {
        return this._ownerTraversal;
    }

    private void _reinit(XmlContext context, XmlKey key, Node node, Node ownerNode, XmlKey ownerKey, Node nearestAncestor, Node targetNode) {
        this._xmlContext = context;
        this._key = key;
        this._node = node;
        this._ownerNode = ownerNode;
        this._ownerKey = ownerKey;
        this._nearestAncestor = nearestAncestor;
        this._targetNode = targetNode;
        this._ownerTraversal = XmlModelUtils.getPropertyEditorOwnerTraversal(this._targetNode);
    }

    private void _clear() {
        this._xmlContext = null;
        this._key = null;
        this._node = null;
        this._ownerNode = null;
        this._ownerKey = null;
        this._nearestAncestor = null;
        this._targetNode = null;
        this._ownerTraversal = null;
    }

    private PropertyEditorContext() {
    }
}

