/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.id;

import java.util.HashMap;
import oracle.bali.xml.model.id.IdGenerationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Scope {
    private final Node _contextNode;
    private final String _scopeIdentifier;
    private static final String _DOCUMENT_SCOPE_CACHE = "document-scope-cache";

    public static Scope findOrCreateDocumentRootedScope(IdGenerationContext context, String scopeIdentifier) {
        Scope scope;
        HashMap<String, Scope> cache = (HashMap<String, Scope>)context.getProperty(_DOCUMENT_SCOPE_CACHE);
        if (cache == null) {
            cache = new HashMap<String, Scope>();
            context.putProperty(_DOCUMENT_SCOPE_CACHE, cache);
        }
        if ((scope = (Scope)cache.get(scopeIdentifier)) == null) {
            Document document = context.getModel().getDocument();
            scope = new Scope(document, scopeIdentifier);
            cache.put(scopeIdentifier, scope);
        }
        return scope;
    }

    public static Scope findOrCreateElementRootedScope(IdGenerationContext context, Element element, String scopeIdentifier) {
        return new Scope(element, scopeIdentifier);
    }

    public final Node getContextNode() {
        return this._contextNode;
    }

    public final String getScopeIdentifier() {
        return this._scopeIdentifier;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Scope)) {
            return false;
        }
        Scope other = (Scope)object;
        if (!(this._contextNode != null ? this._contextNode.equals(other._contextNode) : other._contextNode == null)) {
            return false;
        }
        return this._scopeIdentifier != null ? this._scopeIdentifier.equals(other._scopeIdentifier) : other._scopeIdentifier == null;
    }

    public int hashCode() {
        int PRIME = 37;
        int result = 1;
        result = 37 * result + (this._contextNode == null ? 0 : this._contextNode.hashCode());
        result = 37 * result + (this._scopeIdentifier == null ? 0 : this._scopeIdentifier.hashCode());
        return result;
    }

    public Scope(Node contextNode, String scopeIdentifier) {
        if (contextNode == null) {
            throw new IllegalArgumentException("null contextNode argument");
        }
        if (scopeIdentifier == null) {
            throw new IllegalArgumentException("null scopeIdentifier argument");
        }
        this._contextNode = contextNode;
        this._scopeIdentifier = scopeIdentifier;
    }
}

