/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.grammar;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.grammar.remote.DefaultGrammarLoadingPolicy;
import oracle.bali.xml.grammar.remote.GrammarLoadingPolicy;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.dependency.ValidationResult;
import oracle.ide.net.URLFileSystem;

public class GrammarLoadingPolicyFactory {
    private static final Map<XmlContext, GrammarLoadingPolicy> _factoryCache = Collections.synchronizedMap(new WeakHashMap());
    private static final Logger _sLogger = Logger.getLogger(GrammarLoadingPolicyFactory.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GrammarLoadingPolicy getGrammarLoadingPolicy(XmlContext referringXmlContext) {
        if (referringXmlContext == null) {
            throw new IllegalArgumentException("Null referringXmlContext argument passed to getRemoteSchemaPolicy()");
        }
        Object policyForContext = _factoryCache.get(referringXmlContext);
        if (policyForContext == null) {
            Map<XmlContext, GrammarLoadingPolicy> map = _factoryCache;
            synchronized (map) {
                policyForContext = _factoryCache.get(referringXmlContext);
                if (policyForContext == null) {
                    policyForContext = new ModelAwareGrammarLoadingPolicy(referringXmlContext);
                    _factoryCache.put(referringXmlContext, (GrammarLoadingPolicy)policyForContext);
                }
            }
        }
        return policyForContext;
    }

    private static class ModelAwareGrammarLoadingPolicy
    extends DefaultGrammarLoadingPolicy {
        private final WeakReference<XmlContext> xmlContextReference;
        private URL xmlContextUrl = null;

        public ModelAwareGrammarLoadingPolicy(XmlContext xmlContext) {
            this.xmlContextReference = new WeakReference<XmlContext>(xmlContext);
            this.xmlContextUrl = xmlContext.getURL();
        }

        public boolean isRemote(URL url) {
            if (URLFileSystem.isLocal((URL)url)) {
                return false;
            }
            String protocol = url.getProtocol();
            return !"bundleentry".equals(protocol) && !"bundleresource".equals(protocol);
        }

        public GrammarLoadingPolicy.Policy getPolicy(URL url, GrammarLoadingPolicy.Type type) {
            ValidationResult modelResult = this._getModelValidationResult(url);
            if (modelResult != null) {
                if (modelResult == ValidationResult.OK) {
                    return GrammarLoadingPolicy.Policy.LOAD;
                }
                return GrammarLoadingPolicy.Policy.ERROR_UNREACHABLE;
            }
            if (this.isRemote(url) && this.isSameHost(url)) {
                if (this.performConnectionTest(url, true)) {
                    return GrammarLoadingPolicy.Policy.LOAD;
                }
                return GrammarLoadingPolicy.Policy.ERROR_UNREACHABLE;
            }
            return super.getPolicy(url, type);
        }

        protected boolean performConnectionTestImpl(URL url) {
            return URLFileSystem.exists((URL)url);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ValidationResult _getModelValidationResult(URL url) {
            ValidationResult result = null;
            XmlContext xmlContext = (XmlContext)this.xmlContextReference.get();
            if (xmlContext != null) {
                XmlModel model = xmlContext.getModel();
                model.acquireReadLock();
                try {
                    result = model.getCachedURLValidationResult(url);
                }
                finally {
                    model.releaseReadLock();
                }
            } else {
                _sLogger.log(Level.SEVERE, "Illegal attempt to use ModelAwareRemoteSchemaPolicy beyond lifetime of XmlContext");
            }
            return result;
        }

        public boolean isSameHost(URL url) {
            if (this.xmlContextUrl != null) {
                return this.xmlContextUrl.getProtocol().equals(url.getProtocol()) && this.xmlContextUrl.getHost().equals(url.getHost());
            }
            return false;
        }
    }
}

