/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.dependency.id;

import java.util.HashMap;
import java.util.List;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.dependency.DependencyContext;
import oracle.bali.xml.model.dependency.FindUsagesCallback;
import oracle.bali.xml.model.dependency.XmlDeclaration;
import oracle.bali.xml.model.traversal.MutableTraversalData;
import oracle.bali.xml.model.traversal.TraversalData;
import oracle.bali.xml.model.traversal.TraversalHandler;
import org.w3c.dom.Node;

public class IdDeclaration
extends XmlDeclaration
implements TraversalHandler {
    public static final String ID_DECLS = "XSD_ID_DECLARATIONS";

    public IdDeclaration(XmlContext xmlContext, Node node, int start, int end) {
        super(xmlContext, node, start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void findUsages(DependencyContext context, FindUsagesCallback callback) {
        XmlModel model = this.getXmlContext(context).getModel();
        model.acquireReadLock();
        try {
            String value;
            HashMap map;
            TraversalData data = context.getTraversalData(model.getContext());
            if (data.containsKey(this.getReferenceId()) && (map = (HashMap)data.get(this.getReferenceId())).containsKey(value = this.getValue(context))) {
                List idRefs = (List)map.get(value);
                callback.addReferences(idRefs);
            }
        }
        finally {
            model.releaseReadLock();
        }
    }

    @Override
    protected String getDisplayNameImpl(DependencyContext context) {
        return "Id: '" + this.getValue(context) + "'";
    }

    protected String getDeclarationId() {
        return ID_DECLS;
    }

    protected String getReferenceId() {
        return "XSD_ID_REFERENCES";
    }

    @Override
    public void handleStartNode(XmlModel model, Node node, MutableTraversalData data) {
        HashMap<String, IdDeclaration> map = (HashMap<String, IdDeclaration>)data.get(this.getDeclarationId());
        if (map == null) {
            map = new HashMap<String, IdDeclaration>();
        }
        map.put(this.getValue(node), this);
        data.put(this.getDeclarationId(), map);
    }

    @Override
    public void handleEndNode(XmlModel model, Node node, MutableTraversalData data) {
    }

    protected final String getValue(Node node) {
        String textValue = DomUtils.getTextNodeValue((Node)node);
        return textValue.substring(this.getStartIndex(), this.getEndIndex());
    }
}

