/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.dependency;

import java.lang.ref.WeakReference;
import java.net.URL;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomRange;
import oracle.bali.xml.dom.traversal.DocumentTreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlContextReference;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.dependency.CommandResult;
import oracle.bali.xml.model.dependency.Declaration;
import oracle.bali.xml.model.dependency.DependencyContext;
import oracle.bali.xml.model.dependency.DependencyUtils;
import oracle.bali.xml.model.dependency.ReferenceBase;
import oracle.bali.xml.model.dependency.ValidationResult;
import oracle.bali.xml.model.dependency.ValueInfo;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.share.TransactionToken;
import oracle.javatools.status.Severity;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class XmlReference
extends ReferenceBase {
    private XmlContextReference _xmlContextRef;
    private WeakReference _weakNode;
    private URL _fileUrl;
    private String _nodePath;
    private String _attributeNS;
    private String _attribute;
    private int _start;
    private int _end;

    public XmlReference(XmlContext xmlContext, Node node, int start, int end) {
        this._xmlContextRef = xmlContext.getXmlContextReference();
        this._fileUrl = xmlContext.getURL();
        this._weakNode = new WeakReference<Node>(node);
        if (DomUtils.isAttribute((Node)node)) {
            Attr attr = (Attr)node;
            this._attribute = DomUtils.getLocalName((Node)attr);
            String attrNS = attr.getNamespaceURI();
            if (attrNS != null) {
                this._attributeNS = attrNS;
            }
            node = attr.getOwnerElement();
        }
        this._nodePath = DependencyUtils.createNodePathString(node);
        this._start = start;
        this._end = end;
    }

    @Override
    public ValidationResult validateDeclaration(DependencyContext context, Declaration declaration) {
        if (declaration != null) {
            return ValidationResult.OK;
        }
        String value = this.getValue(context);
        String msg = value != null && !"".equals(value) ? String.format("Reference %s not found", value) : "Reference not found";
        return new ValidationResult(Severity.WARNING, msg);
    }

    public DomRange getDomRange(DependencyContext context) {
        Node node = this.getNode(context);
        return DomRange.create((DomPosition)DependencyUtils.__getDomPosition(node, this._start), (DomPosition)DependencyUtils.__getDomPosition(node, this._end), (TreeTraversal)DocumentTreeTraversal.INSTANCE);
    }

    @Override
    protected String getDisplayTextImpl(DependencyContext context) {
        return context.getDisplayText(this.getXmlContext(context), this.getNode(context));
    }

    @Override
    protected boolean supportsUpdateReference() {
        return true;
    }

    @Override
    protected CommandResult updateReferenceImpl(final DependencyContext context, final ValueInfo value) {
        boolean didTxn = new FixedNameTransactionTask("Update reference"){

            @Override
            protected void performTask(AbstractModel model) throws XmlCommitException {
                Object prop = context.getTransientProperty("transactionToken");
                if (prop != null) {
                    model.getContext().setTransactionToken((TransactionToken)prop);
                }
                XmlReference.this.updateValue(context, value);
            }
        }.run(this.getXmlContext(context).getModel());
        if (!didTxn) {
            String format = this.getXmlContext(context).getTranslatedString("REFERENCE_UPDATE_FAILURE");
            String message = FastMessageFormat.formatMessage(format, (String)this.getMetadata(context, "displayNameMetadata"));
            return new CommandResult(Severity.ERROR, message);
        }
        return CommandResult.OK;
    }

    @Override
    protected boolean supportsGotoSelf() {
        return true;
    }

    @Override
    protected CommandResult gotoSelfImpl(DependencyContext context) {
        context.gotoDeclRef(this.getXmlContext(context), this.getNode(context));
        return CommandResult.OK;
    }

    protected final XmlContext getXmlContext(DependencyContext context) {
        return this._xmlContextRef.getXmlContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Node getNode(DependencyContext context) {
        XmlModel model = this.getXmlContext(context).getModel();
        model.acquireReadLock();
        try {
            Node node = (Node)this._weakNode.get();
            if (node == null || !DomUtils.isNodeOrDescendant((Node)node, (Node)model.getDocument())) {
                node = DependencyUtils.getNodeFromInfo(this.getXmlContext(context), this._nodePath, this._attributeNS, this._attribute);
                this._weakNode = new WeakReference<Node>(node);
            }
            Node node2 = node;
            return node2;
        }
        finally {
            model.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String getValue(DependencyContext context) {
        XmlModel model = this.getXmlContext(context).getModel();
        model.acquireReadLock();
        try {
            Node node = this.getNode(context);
            String textValue = DependencyUtils.getTextContent(node);
            String string = textValue.substring(this._start, this._end);
            return string;
        }
        finally {
            model.releaseReadLock();
        }
    }

    protected final int getStartIndex() {
        return this._start;
    }

    protected final int getEndIndex() {
        return this._end;
    }

    protected final URL getFileURL() {
        return this._fileUrl;
    }

    protected void updateValue(DependencyContext context, ValueInfo value) {
        Node node = this.getNode(context);
        String currValue = DependencyUtils.getTextContent(node);
        StringBuilder builder = new StringBuilder(currValue);
        builder.replace(this._start, this._end, value.getNewValue());
        if (DomUtils.isAttribute((Node)node)) {
            node.setNodeValue(builder.toString());
        } else if (node.getNodeType() == 8) {
            ((Comment)node).setData(builder.toString());
        } else {
            int currPos = 0;
            if (node.hasChildNodes()) {
                NodeList children = node.getChildNodes();
                block3: for (int i = 0; i < children.getLength(); ++i) {
                    Node child = children.item(i);
                    switch (child.getNodeType()) {
                        case 3: 
                        case 4: {
                            String curValue = child.getNodeValue();
                            StringBuilder valBuilder = new StringBuilder(curValue);
                            int valStart = currPos;
                            int valEnd = currPos + curValue.length();
                            if (valStart <= this._start && valEnd > this._start) {
                                if (valEnd >= this._end) {
                                    valBuilder.replace(this._start - valStart, this._end - valStart, value.getNewValue());
                                    child.setNodeValue(valBuilder.toString());
                                    continue block3;
                                }
                                valBuilder.replace(this._start - valStart, curValue.length(), value.getNewValue());
                                child.setNodeValue(valBuilder.toString());
                            } else if (valStart > this._start && valStart < this._end) {
                                if (valEnd > this._end) {
                                    valBuilder.delete(0, this._end - valStart);
                                    child.setNodeValue(valBuilder.toString());
                                    continue block3;
                                }
                                if (valEnd <= this._end) {
                                    node.removeChild(child);
                                }
                            }
                            currPos = valEnd;
                        }
                    }
                }
            } else {
                Text textNode = node.getOwnerDocument().createTextNode(builder.toString());
                node.appendChild(textNode);
            }
        }
        this._end = this._start + value.getNewValue().length();
    }
}

