/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.bali.share.util.IntegerUtils;
import oracle.bali.xml.dom.position.DomRange;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.creatable.XmlCreatable;
import oracle.bali.xml.model.creatable.XmlCreationContext;
import oracle.bali.xml.model.task.NoNameTransactionTask;
import oracle.bali.xml.share.BogusSerializableData;
import oracle.bali.xml.share.MutableBoolean;
import oracle.bali.xml.share.TransactionToken;
import oracle.bali.xml.share.UnmodifiableArrayList;
import oracle.bali.xml.util.XmlModelUtils;
import oracle.javatools.datatransfer.AugmentableTransferable;
import oracle.javatools.datatransfer.DataTransferPluginRegistry;
import oracle.javatools.datatransfer.ExtendedTransferable;
import oracle.javatools.datatransfer.FetchMode;
import oracle.javatools.datatransfer.TransferDataInfo;
import oracle.javatools.datatransfer.TransferUtils;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XmlTransferUtils {
    public static final Object KEY_SOURCEMODEL_REF = "source AbstractModel reference";
    public static final Object KEY_SOURCEMODEL_CHANGE_COUNT = "source AbstractModel change count";
    public static final Object KEY_ORIGINAL_NODES_COLLECTION = "original node collection";
    public static final Object KEY_ORIGINAL_RANGE = "original range";
    public static final Object KEY_XMLKEY_LIST = "XmlKey list";
    public static final Object KEY_TARGET_HANDLED_MOVE = "target handled move";
    public static final Object KEY_TASK_TO_EXECUTE_AFTER_INSERTING_FRAGMENT = "KEY_TASK_TO_EXECUTE_AFTER_INSERTING_FRAGMENT";
    public static final Object KEY_SUBGROUP_NAME = "KEY_SUBGROUP_NAME";
    public static final DataFlavor FLAVOR_XMLKEY = TransferUtils.createLocalJvmFlavor(XmlKey.class, (ClassLoader)XmlKey.class.getClassLoader());
    public static final DataFlavor FLAVOR_XMLCREATABLE = TransferUtils.createLocalJvmFlavor(XmlCreatable.class, (ClassLoader)XmlCreatable.class.getClassLoader());
    public static final DataFlavor FLAVOR_DOCUMENTFRAGMENT = TransferUtils.createLocalJvmFlavor(DocumentFragment.class, (ClassLoader)DocumentFragment.class.getClassLoader());
    public static final DataFlavor FLAVOR_NODELIST = TransferUtils.createLocalJvmFlavor(NodeList.class, (ClassLoader)NodeList.class.getClassLoader());
    public static final DataFlavor FLAVOR_TRANSACTIONTOKEN = TransferUtils.createLocalJvmFlavor(TransactionToken.class, (ClassLoader)TransactionToken.class.getClassLoader());
    private static final int _MAX_SHORT_NAME_SIZE = 20;
    private static final int _MAX_MEDIUM_NAME_SIZE = 35;
    private static final int _MAX_LONG_NAME_SIZE = Integer.MAX_VALUE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AugmentableTransferable createXmlKeyTransferable(AbstractModel model, XmlKey key) {
        AugmentableTransferable trans = TransferUtils.createTransferable();
        TreeMap<Object, String> md = new TreeMap<Object, String>();
        model.acquireReadLock();
        try {
            XmlMetadataResolver resolver = model.getXmlMetadataResolver();
            md.put(TransferDataInfo.METADATA_SHORT_DESCRIPTION, resolver.getShortDisplayName(key));
            md.put(TransferDataInfo.METADATA_MEDIUM_DESCRIPTION, resolver.getMediumDisplayName(key));
            md.put(TransferDataInfo.METADATA_LONG_DESCRIPTION, resolver.getLongDisplayName(key));
        }
        finally {
            model.releaseReadLock();
        }
        trans.augment(TransferUtils.createDataInfo((DataFlavor)FLAVOR_XMLKEY, (Object)key, (float)0.9f, md));
        XmlTransferUtils.addBogusSerializableFlavor(trans);
        return trans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AugmentableTransferable createXmlCreatableTransferable(XmlCreationContext creationContext, XmlCreatable xmlCreatable) {
        AugmentableTransferable trans = TransferUtils.createTransferable();
        AbstractModel model = creationContext.getModel();
        TreeMap<Object, String> md = new TreeMap<Object, String>();
        model.acquireReadLock();
        try {
            md.put(TransferDataInfo.METADATA_SHORT_DESCRIPTION, xmlCreatable.getShortDisplayName(creationContext));
            md.put(TransferDataInfo.METADATA_MEDIUM_DESCRIPTION, xmlCreatable.getMediumDisplayName(creationContext));
            md.put(TransferDataInfo.METADATA_LONG_DESCRIPTION, xmlCreatable.getLongDisplayName(creationContext));
        }
        finally {
            model.releaseReadLock();
        }
        trans.augment(TransferUtils.createDataInfo((DataFlavor)FLAVOR_XMLCREATABLE, (Object)xmlCreatable, (float)0.901f, md));
        XmlTransferUtils.addBogusSerializableFlavor(trans);
        return trans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AugmentableTransferable createDomNodesTransferable(AbstractModel model, Collection nodes, DomRange range, boolean provideMoveInfo) {
        if (nodes == null || model == null) {
            throw new IllegalArgumentException("null argument");
        }
        AugmentableTransferable trans = TransferUtils.createTransferable();
        DocumentFragment fragment = null;
        HashMap<Object, Object> md = new HashMap<Object, Object>(7);
        if (range != null) {
            md.put(KEY_ORIGINAL_RANGE, range);
        } else {
            md.put(KEY_ORIGINAL_NODES_COLLECTION, new ArrayList(nodes));
        }
        if (provideMoveInfo) {
            md.put(KEY_SOURCEMODEL_REF, new WeakReference<AbstractModel>(model));
            md.put(KEY_TARGET_HANDLED_MOVE, new MutableBoolean(false));
        }
        ArrayList<XmlKey> keys = new ArrayList<XmlKey>(nodes.size());
        md.put(KEY_XMLKEY_LIST, keys);
        model.acquireReadLock();
        try {
            md.put(KEY_SOURCEMODEL_CHANGE_COUNT, IntegerUtils.getInteger((int)model.getBaseModel().getDocChangeCount()));
            XmlMetadataResolver resolver = model.getXmlMetadataResolver();
            StringBuffer shortNameBuf = new StringBuffer();
            StringBuffer mediumNameBuf = new StringBuffer();
            StringBuffer longNameBuf = new StringBuffer();
            String separator = model.getTranslatedString("LIST_SEPARATOR");
            Document scratchDocument = DomUtils.getScratchDocument();
            for (Node node : nodes) {
                keys.add(model.getNodeXmlKey(node));
                if (fragment == null) {
                    fragment = scratchDocument.createDocumentFragment();
                }
                fragment.appendChild(scratchDocument.importNode(node, true));
                XmlTransferUtils._appendIfNonNull(shortNameBuf, resolver.getShortDisplayName(node), separator);
                XmlTransferUtils._appendIfNonNull(mediumNameBuf, resolver.getMediumDisplayName(node), separator);
                XmlTransferUtils._appendIfNonNull(longNameBuf, resolver.getLongDisplayName(node), separator);
            }
            XmlTransferUtils._setBufferIfNotEmpty(md, TransferDataInfo.METADATA_SHORT_DESCRIPTION, shortNameBuf, 20);
            XmlTransferUtils._setBufferIfNotEmpty(md, TransferDataInfo.METADATA_MEDIUM_DESCRIPTION, mediumNameBuf, 35);
            XmlTransferUtils._setBufferIfNotEmpty(md, TransferDataInfo.METADATA_LONG_DESCRIPTION, longNameBuf, Integer.MAX_VALUE);
        }
        finally {
            model.releaseReadLock();
        }
        float rank = 0.9f;
        if (fragment != null) {
            trans.augment(TransferUtils.createDataInfo((DataFlavor)FLAVOR_DOCUMENTFRAGMENT, (Object)fragment, (float)TransferUtils.lowerRank((float)rank), md));
        }
        XmlTransferUtils.addBogusSerializableFlavor(trans);
        return trans;
    }

    public static AugmentableTransferable createDomNodesTransferable(AbstractModel model, Collection nodes, boolean provideMoveInfo) {
        return XmlTransferUtils.createDomNodesTransferable(model, nodes, null, provideMoveInfo);
    }

    public static AugmentableTransferable createDomNodesTransferable(AbstractModel model, NodeList nodes) {
        return XmlTransferUtils.createDomNodesTransferable(model, DomUtils.nodeListToList((NodeList)nodes), true);
    }

    public static AugmentableTransferable createDomNodesTransferable(AbstractModel model, Node node) {
        return XmlTransferUtils.createDomNodesTransferable(model, Collections.singletonList(node), true);
    }

    public static AugmentableTransferable createDomNodesTransferable(AbstractModel model, Node[] nodes) {
        return XmlTransferUtils.createDomNodesTransferable(model, new UnmodifiableArrayList<Node>(nodes), true);
    }

    public static void addBogusSerializableFlavor(AugmentableTransferable trans) {
        trans.augment(TransferUtils.createDataInfo((DataFlavor)BogusSerializableData.FLAVOR, null, (float)0.0f, null));
    }

    public static String getShortDescription(AbstractModel model, Transferable trans) {
        if (trans instanceof ExtendedTransferable) {
            ExtendedTransferable et = (ExtendedTransferable)trans;
            return et.getShortDescription();
        }
        return null;
    }

    public static String getMediumDescription(AbstractModel model, Transferable trans) {
        if (trans instanceof ExtendedTransferable) {
            ExtendedTransferable et = (ExtendedTransferable)trans;
            return et.getMediumDescription();
        }
        return null;
    }

    public static List getXmlKeys(Transferable trans) {
        Object ret = TransferUtils.getDataIfAvailable((Transferable)trans, (DataFlavor)FLAVOR_XMLKEY);
        if (ret instanceof XmlKey) {
            return Collections.singletonList(ret);
        }
        return null;
    }

    public static NodeList getNodeList(Transferable trans) {
        Object ret = TransferUtils.getDataIfAvailable((Transferable)trans, (DataFlavor)FLAVOR_NODELIST);
        if (ret instanceof NodeList) {
            return (NodeList)ret;
        }
        return null;
    }

    public static TransactionToken getTransactionToken(Transferable transferable) {
        return (TransactionToken)TransferUtils.getDataIfAvailable((Transferable)transferable, (DataFlavor)FLAVOR_TRANSACTIONTOKEN, TransactionToken.class, (FetchMode)FetchMode.STANDARD);
    }

    public static AbstractModel getSourceModel(TransferDataInfo data) {
        Reference ref = (Reference)data.getMetadata(KEY_SOURCEMODEL_REF);
        return ref == null ? null : (AbstractModel)ref.get();
    }

    public static Collection getOriginalNodes(TransferDataInfo data) {
        return (Collection)data.getMetadata(KEY_ORIGINAL_NODES_COLLECTION);
    }

    public static DomRange getOriginalRange(TransferDataInfo data) {
        return (DomRange)data.getMetadata(KEY_ORIGINAL_RANGE);
    }

    public static boolean hasOriginalNodesOrRange(TransferDataInfo data) {
        return data.getMetadata(KEY_ORIGINAL_NODES_COLLECTION) != null || data.getMetadata(KEY_ORIGINAL_RANGE) != null;
    }

    public static void removeOriginalNodes(final String txnName, final TransferDataInfo data, final DomRange range, final Collection originalNodes, final TransactionToken token, final boolean updateSelection) throws XmlCommitException {
        if (range == null && originalNodes == null) {
            throw new IllegalArgumentException("neither nodes nor range provided");
        }
        AbstractModel model = XmlTransferUtils.getSourceModel(data);
        if (model == null) {
            throw new IllegalArgumentException("data has no source model");
        }
        new NoNameTransactionTask(){

            @Override
            protected void performTask(AbstractModel model) throws XmlCommitException {
                model.getContext().setTransactionToken(token);
                int nowChange = model.getBaseModel().getDocChangeCount();
                Integer origChange = (Integer)data.getMetadata(KEY_SOURCEMODEL_CHANGE_COUNT);
                if (origChange == null || origChange != nowChange) {
                    throw new IllegalArgumentException("wrong change count! count at transferable creation=" + origChange + " count now=" + nowChange + " model=" + model);
                }
                XmlModelUtils.deleteNodesOrRange(model, txnName, originalNodes, range, updateSelection);
            }
        }.runThrowingXCE(model);
    }

    public static AugmentableTransferable performAugmentation(Transferable trans, XmlContext context) {
        AugmentableTransferable augmentable = TransferUtils.createTransferable((Transferable)trans);
        ArrayList<DataTransferPluginRegistry> registries = new ArrayList<DataTransferPluginRegistry>(2);
        registries.add(context.getDataTransferPluginRegistry());
        registries.add(DataTransferPluginRegistry.getGlobalInstance());
        DataTransferPluginRegistry.performAugmentation((AugmentableTransferable)augmentable, registries);
        return augmentable;
    }

    private static void _appendIfNonNull(StringBuffer buf, String item, String separator) {
        if (item != null) {
            if (buf.length() > 0) {
                buf.append(separator);
            }
            buf.append(item);
        }
    }

    private static void _setBufferIfNotEmpty(Map map, Object key, StringBuffer value, int maxLength) {
        int length = value.length();
        if (length > 0 && length <= maxLength) {
            map.put(key, value.toString());
        }
    }

    private XmlTransferUtils() {
    }
}

