/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.annotation.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.model.PrecommitOptions;
import oracle.bali.xml.model.PrecommitResults;
import oracle.bali.xml.model.TransactionOptions;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlModelListener;
import oracle.bali.xml.model.annotation.AnnotationCommitException;
import oracle.bali.xml.model.annotation.AnnotationModel;
import oracle.bali.xml.model.event.XmlModelAdapter;
import oracle.bali.xml.share.TransactionToken;
import oracle.bali.xml.share.WeakListenerProxy;

public abstract class SideFileAnnotationModel
extends AnnotationModel {
    private static Logger _sLogger = null;
    private XmlContext _sideFileContext;
    private XmlModelListener _sideFileListener;
    private XmlModelListener _sideFileListenerWeakProxy;
    private volatile boolean _inCommitPhase = false;

    public SideFileAnnotationModel(XmlContext instanceContext, XmlContext sideFileContext) {
        super(instanceContext);
        if (sideFileContext == null) {
            throw new IllegalArgumentException("SideFileAnnotationModel: Passed null side file XmlModel");
        }
        this._attachToSideFileContext(sideFileContext);
    }

    @Override
    public void acquireReadLock() {
        this.getSideFileModel().acquireReadLock();
    }

    @Override
    public void releaseReadLock() {
        this.getSideFileModel().releaseReadLock();
    }

    @Override
    public void acquireWriteLock() {
        this.getSideFileModel().getDomModel().acquireWriteLock();
    }

    @Override
    public void releaseWriteLock() {
        this.getSideFileModel().getDomModel().releaseWriteLock();
    }

    @Override
    public void startTransaction(TransactionOptions transOptions) {
        this.getSideFileModel().startTransaction(transOptions);
    }

    @Override
    public AnnotationCommitException precommitTransaction(PrecommitOptions options) {
        XmlModel model = this.getSideFileModel();
        PrecommitResults precommitResults = this.getSideFileContext().precommitTransaction(model, options);
        if (!precommitResults.precommitSucceeded()) {
            XmlCommitException fatalException = precommitResults.getFatalException();
            return new AnnotationCommitException(this, "SideFileAnnotationModel: Side File PrecommitTransaction Failed (See Chained XmlCommitException)", (Throwable)fatalException);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitTransaction(TransactionToken token) {
        this._inCommitPhase = true;
        boolean stillValid = true;
        try {
            if (token != null) {
                this.getSideFileContext().setTransactionToken(token);
                if (this.getSideFileModel().getDomModel().getChangeTarget() != null && this.getInstanceModel().getDomModel().getChangeTarget() == null) {
                    this.getInstanceContext().addNoOpUndoableEdit(token.getName());
                }
            }
            stillValid = this.getSideFileModel().commitTransaction(false);
        }
        catch (Throwable t) {
            this.getSideFileModel().rollbackTransaction();
            this.getLogger().log(Level.SEVERE, "Unexpected Throwable Caught During SideFileAnnotationModel.commitTransaction()", t);
        }
        finally {
            this._inCommitPhase = false;
        }
        return stillValid;
    }

    @Override
    public void rollbackTransaction() {
        this.getSideFileModel().rollbackTransaction();
    }

    @Override
    public boolean isReadOnly() {
        return this.getSideFileModel().isReadOnly();
    }

    public final XmlContext getSideFileContext() {
        return this._sideFileContext;
    }

    protected final XmlModel getSideFileModel() {
        return this._sideFileContext.getModel();
    }

    protected final Logger getLogger() {
        if (_sLogger == null) {
            _sLogger = Logger.getLogger(this.getClass().getCanonicalName());
        }
        return _sLogger;
    }

    protected boolean containsAnnotationChanges(XmlModelEvent sideFileEvent) {
        return sideFileEvent.isDomTreeChanged();
    }

    protected void handleSideFileXmlModelChange(XmlModelEvent sideFileEvent, boolean causedByAnnotationModel) {
    }

    protected void replaceSideFileXmlContext(XmlContext newSideFileContext) {
        this._attachToSideFileContext(newSideFileContext);
    }

    private void _attachToSideFileContext(XmlContext newSideFileContext) {
        this._sideFileContext = newSideFileContext;
        this._sideFileListener = new SideFileModelListener();
        this._sideFileListenerWeakProxy = (XmlModelListener)WeakListenerProxy.create(XmlModelListener.class, (Object)this._sideFileListener, XmlModel.class, (Object)this._sideFileContext.getModel(), null);
        this._sideFileContext.getModel().addModelListener(this._sideFileListenerWeakProxy);
    }

    private class SideFileModelListener
    extends XmlModelAdapter {
        @Override
        public void invalidate(XmlModelEvent sideFileEvent) {
            if (SideFileAnnotationModel.this.containsAnnotationChanges(sideFileEvent)) {
                SideFileAnnotationModel.this.handleSideFileXmlModelChange(sideFileEvent, SideFileAnnotationModel.this._inCommitPhase);
            }
        }

        @Override
        public void modelChanged(XmlModelEvent sideFileEvent) {
            if (SideFileAnnotationModel.this.containsAnnotationChanges(sideFileEvent)) {
                SideFileAnnotationModel.this.fireAnnotationModelChangedEvent();
            }
        }
    }
}

