/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.inspector.editors;

import java.net.URI;
import java.net.URISyntaxException;
import oracle.bali.xml.gui.base.inspector.editors.AbstractSimplePropretyEditor;

public class URIEditor
extends AbstractSimplePropretyEditor<URI> {
    public URIEditor() {
        super(URI.class);
    }

    @Override
    protected String getJavaInitializationStringImpl(URI value) {
        return "new java.net.URI(" + value.toString() + ")";
    }

    @Override
    protected URI getValueForString(String string) {
        if (string == null || "".equals(string)) {
            return null;
        }
        try {
            return new URI(string);
        }
        catch (URISyntaxException e) {
            String msg = "An invalid URI was entered by the user. The following problem was detected: \n" + e.getMessage();
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    protected String getStringForValue(URI value) {
        return value.toString();
    }
}

