/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.inspector;

import java.text.Collator;
import java.util.Comparator;
import oracle.bali.xml.gui.base.inspector.BaseInspectorGui;
import oracle.bali.xml.gui.base.inspector.PropertyRow;
import oracle.javatools.util.ModelUtil;

abstract class Comparators<T> {
    private static final Comparators<PropertyRow> _PROPERTY_ROW_INSTANCE = new Comparators<PropertyRow>(){

        @Override
        protected Object getColumnValue(PropertyRow row, int column) {
            return row.getColumnValue(column);
        }
    };

    Comparators() {
    }

    public static final Comparator<PropertyRow> createPropertyRowComparator(BaseInspectorGui gui) {
        return _PROPERTY_ROW_INSTANCE.createComparator(gui);
    }

    public final Comparator<T> createComparator(BaseInspectorGui gui) {
        Collator collator = Collator.getInstance(gui.getGuiContext().getLocale());
        BooleanColValComparator requiredComparator = new BooleanColValComparator(19);
        DisplayOrderColValComparator displayOrderComparator = new DisplayOrderColValComparator(22);
        BooleanColValComparator favoritePropertyComparator = new BooleanColValComparator(24);
        BooleanColValComparator preferredComparator = new BooleanColValComparator(23);
        StringColValComparator alpha = new StringColValComparator(1, collator);
        return MultiComparator.create(requiredComparator, displayOrderComparator, favoritePropertyComparator, preferredComparator, alpha);
    }

    protected abstract Object getColumnValue(T var1, int var2);

    private static class MultiComparator<T>
    implements Comparator<T> {
        private Comparator<T>[] _comparators;

        public static <T> Comparator<T> create(Comparator<T> ... comparators) {
            return new MultiComparator<T>(comparators);
        }

        private MultiComparator(Comparator<T> ... comparators) {
            this._comparators = comparators;
        }

        @Override
        public int compare(T o1, T o2) {
            for (Comparator<T> comp : this._comparators) {
                int ret = comp.compare(o1, o2);
                if (ret == 0) continue;
                return ret;
            }
            return 0;
        }
    }

    private class StringColValComparator
    extends ColValComparator<String> {
        private final Collator _collator;

        public StringColValComparator(int col, Collator collator) {
            super(String.class, col);
            this._collator = collator;
        }

        @Override
        protected int compareValues(String a, String b) {
            return this._collator.compare(a, b);
        }
    }

    private class BooleanColValComparator
    extends ColValComparator<Boolean> {
        public BooleanColValComparator(int col) {
            super(Boolean.class, col);
        }

        @Override
        protected int compareValues(Boolean a, Boolean b) {
            if (a.booleanValue()) {
                return -1;
            }
            return 1;
        }
    }

    private class DisplayOrderColValComparator
    extends ColValComparator<Integer> {
        public DisplayOrderColValComparator(int col) {
            super(Integer.class, col);
        }

        @Override
        protected int compareValues(Integer a, Integer b) {
            int d1 = a;
            int d2 = b;
            int ret = (d1 = Math.max(-1, d1)) == (d2 = Math.max(-1, d2)) ? 0 : (d1 < 0 ? 1 : (d2 < 0 ? -1 : d1 - d2));
            return ret;
        }
    }

    private abstract class ColValComparator<V>
    implements Comparator<T> {
        private final int _col;
        private final Class<V> _type;

        public ColValComparator(Class<V> type, int col) {
            this._type = type;
            this._col = col;
        }

        @Override
        public final int compare(T o1, T o2) {
            Object v2;
            Object v1 = ModelUtil.as((Object)Comparators.this.getColumnValue(o1, this._col), this._type);
            if (v1 == (v2 = ModelUtil.as((Object)Comparators.this.getColumnValue(o2, this._col), this._type))) {
                return 0;
            }
            if (v1 == null) {
                return 1;
            }
            if (v2 == null) {
                return -1;
            }
            if (v1.equals(v2)) {
                return 0;
            }
            return this.compareValues(v1, v2);
        }

        protected abstract int compareValues(V var1, V var2);
    }
}

