/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.inspector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import oracle.bali.xml.gui.base.inspector.BaseInspectorGui;
import oracle.bali.xml.gui.base.inspector.PropertyRow;
import oracle.bali.xml.gui.base.inspector.PropertyRowColumnUtils;
import oracle.bali.xml.gui.base.inspector.PropertyRowCreator;
import oracle.bali.xml.gui.base.inspector.PropertyRowOwner;

abstract class BasePropertyRowCreator<KeyType, RowInfoType, ModelObjType>
extends PropertyRowCreator {
    BasePropertyRowCreator() {
    }

    @Override
    public final List<PropertyRow> getProperties(BaseInspectorGui gui, PropertyRowOwner owner) {
        if (!this.supportsAnyProperties(gui, owner)) {
            return Collections.emptyList();
        }
        List<RowInfoType> grammarInfos = this.getGrammarBasedRowInfos(gui, owner);
        Map<KeyType, ModelObjType> modelObjs = this.getModelObjects(gui, owner);
        ArrayList<PropertyRow> grammarRows = new ArrayList<PropertyRow>(grammarInfos.size());
        for (RowInfoType info : grammarInfos) {
            KeyType key = this.getKeyForRowInfo(info);
            ModelObjType modelObj = modelObjs.remove(key);
            this._addRow(grammarRows, gui, owner, info, key, modelObj);
        }
        Comparator<PropertyRow> rowComparator = gui.__getRowComparator();
        if (!this.areGrammarInfosSorted()) {
            Collections.sort(grammarRows, rowComparator);
        }
        if (modelObjs.isEmpty()) {
            return grammarRows;
        }
        ArrayList<PropertyRow> modelOnlyRows = new ArrayList<PropertyRow>(modelObjs.size());
        for (Map.Entry<KeyType, ModelObjType> entry : modelObjs.entrySet()) {
            this._addRow(modelOnlyRows, gui, owner, null, entry.getKey(), entry.getValue());
        }
        Collections.sort(modelOnlyRows, rowComparator);
        return PropertyRowColumnUtils.mergeSortedLists(grammarRows, modelOnlyRows, rowComparator, false);
    }

    protected boolean areGrammarInfosSorted() {
        return false;
    }

    protected abstract boolean supportsAnyProperties(BaseInspectorGui var1, PropertyRowOwner var2);

    protected abstract KeyType getKeyForRowInfo(RowInfoType var1);

    protected abstract List<RowInfoType> getGrammarBasedRowInfos(BaseInspectorGui var1, PropertyRowOwner var2);

    protected abstract Map<KeyType, ModelObjType> getModelObjects(BaseInspectorGui var1, PropertyRowOwner var2);

    protected abstract PropertyRow createRow(BaseInspectorGui var1, PropertyRowOwner var2, KeyType var3, RowInfoType var4, ModelObjType var5);

    private void _addRow(List<PropertyRow> rows, BaseInspectorGui gui, PropertyRowOwner owner, RowInfoType info, KeyType key, ModelObjType modelObj) {
        PropertyRow row = this.createRow(gui, owner, key, info, modelObj);
        if (row != null) {
            rows.add(row);
        }
    }
}

