/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base;

import java.awt.datatransfer.Transferable;
import java.util.Iterator;
import javax.swing.tree.TreePath;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.base.explorer.XmlTreeModel;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.datatransfer.XmlTransferUtils;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.share.PropertyChange;
import org.w3c.dom.Node;

public abstract class BaseStatusBarGui
extends XmlGui {
    private final FastMessageFormat _dragBeforeFormat = this.getMessageFormat("STATUS_BAR.DRAG_BEFORE_FORMAT");
    private final FastMessageFormat _dragAfterFormat = this.getMessageFormat("STATUS_BAR.DRAG_AFTER_FORMAT");
    private final FastMessageFormat _dragInsideFormat = this.getMessageFormat("STATUS_BAR.DRAG_INSIDE_FORMAT");
    private final FastMessageFormat _insertBeforeFormat = this.getMessageFormat("STATUS_BAR.INSERT_BEFORE_FORMAT");
    private final FastMessageFormat _insertAfterFormat = this.getMessageFormat("STATUS_BAR.INSERT_AFTER_FORMAT");
    private final FastMessageFormat _insertInsideFormat = this.getMessageFormat("STATUS_BAR.INSERT_INSIDE_FORMAT");

    public BaseStatusBarGui(XmlView view) {
        super(view);
    }

    protected abstract void updateSelectionText(boolean var1);

    protected abstract void updateFeedbackText(boolean var1);

    protected abstract void updateInsertionPositionText();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSelectionText(boolean remapSelection) {
        XmlView view = this.getView();
        String selectionString = "";
        Selection selection = view.getSelection();
        view.acquireReadLock();
        try {
            if (!selection.isEmpty()) {
                String separator = this.getTranslatedString("LIST_SEPARATOR");
                StringBuffer selectedText = new StringBuffer(this.getTranslatedString("STATUS_BAR.SELECTED_PREFIX"));
                XmlMetadataResolver resolver = this.getView().getXmlMetadataResolver();
                Iterator<Node> selNodesIter = selection.getSelectedNodes();
                while (selNodesIter.hasNext()) {
                    TreePath nodePath;
                    Node selNode = selNodesIter.next();
                    if (remapSelection && ((nodePath = XmlTreeModel.getPathForDomElement(view, selNode)) == null || (selNode = view.remapNode(XmlTreeModel.getAncestorNodeListFromPath(view, nodePath))) == null)) continue;
                    selectedText.append(resolver.getMediumDisplayName(selNode));
                    if (!selNodesIter.hasNext()) continue;
                    selectedText.append(separator);
                }
                selectionString = selectedText.toString();
            }
        }
        finally {
            view.releaseReadLock();
        }
        return selectionString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getFeedbackText(boolean remapSelection) {
        XmlView view = this.getView();
        Selection selection = view.getSelection();
        view.acquireReadLock();
        try {
            String draggedItemDescription = XmlTransferUtils.getMediumDescription(view, (Transferable)this.getGuiContext().getDropTransferable());
            DomPosition dropLocation = null;
            dropLocation = selection.getDropLocation();
            if (dropLocation != null) {
                Node dropItem = dropLocation.getTargetNode();
                if (remapSelection) {
                    TreePath nodePath = XmlTreeModel.getPathForDomElement(view, dropItem);
                    dropItem = nodePath != null ? view.remapNode(XmlTreeModel.getAncestorNodeListFromPath(view, nodePath)) : null;
                }
                if (dropItem != null) {
                    FastMessageFormat dragFormatKey = null;
                    switch (dropLocation.getRelativePosition()) {
                        case 2: {
                            dragFormatKey = this._dragAfterFormat;
                            break;
                        }
                        case 1: {
                            dragFormatKey = this._dragBeforeFormat;
                            break;
                        }
                        case 0: {
                            dragFormatKey = this._dragInsideFormat;
                        }
                    }
                    String displayName = view.getXmlMetadataResolver().getMediumDisplayName(dropItem);
                    String string = dragFormatKey.format(draggedItemDescription, displayName);
                    return string;
                }
            }
        }
        finally {
            view.releaseReadLock();
        }
        if (!view.getBaseModel().isDocumentValid()) {
            return view.getTranslatedString("DOCUMENT_INVALID");
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getInsertionPositionText() {
        XmlView view = this.getView();
        view.acquireReadLock();
        try {
            DomPosition cursorLocation = view.getSelection().getCursorLocation();
            if (cursorLocation != null) {
                FastMessageFormat insertionFormatKey = null;
                switch (cursorLocation.getRelativePosition()) {
                    case 2: {
                        insertionFormatKey = this._insertAfterFormat;
                        break;
                    }
                    case 1: {
                        insertionFormatKey = this._insertBeforeFormat;
                        break;
                    }
                    case 0: {
                        insertionFormatKey = this._insertInsideFormat;
                    }
                }
                String nodeDisplay = view.getXmlMetadataResolver().getMediumDisplayName(cursorLocation.getTargetNode());
                String string = insertionFormatKey.format(nodeDisplay);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            view.releaseReadLock();
        }
    }

    @Override
    protected void handleModelChangeEvent(XmlModelEvent event) {
        PropertyChange cursorLocationChange;
        super.handleModelChangeEvent(event);
        boolean selectionChanged = event.isSelectionChanged();
        if (selectionChanged) {
            this.updateSelectionText(false);
        }
        if ((cursorLocationChange = event.getCursorLocationPropertyChange()) != null) {
            this.updateInsertionPositionText();
        }
        PropertyChange dropLocationChange = event.getDropLocationPropertyChange();
        PropertyChange validityChange = event.getDomDocumentValidPropertyChange();
        if (dropLocationChange != null || validityChange != null) {
            this.updateFeedbackText(false);
        }
    }
}

