/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.view.proxy;

import oracle.bali.xml.dom.util.DummyNode;
import oracle.bali.xml.dom.view.proxy.ImmutableNodeProxy;
import oracle.bali.xml.dom.view.proxy.ViewDocument;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public abstract class ViewNode
extends ImmutableNodeProxy {
    private Node _proxiedNode;
    private Node _parentNode = DummyNode.INSTANCE;
    private ViewDocument _ownerDocument;
    private Node _nextKnownSibling = DummyNode.INSTANCE;
    private Node _nextSibling = DummyNode.INSTANCE;
    private Node _previousSibling = DummyNode.INSTANCE;

    ViewNode(Node proxiedNode) {
        if (proxiedNode == null) {
            throw new IllegalArgumentException();
        }
        this._proxiedNode = proxiedNode;
    }

    protected void setParentNode(Node parentNode) {
        this._parentNode = parentNode;
    }

    protected void setViewDocument(ViewDocument doc) {
        if (doc == null) {
            throw new IllegalArgumentException();
        }
        this._ownerDocument = doc;
    }

    protected ViewDocument getViewDocument() {
        return this._ownerDocument;
    }

    @Override
    protected Node getProxiedNode() {
        return this._proxiedNode;
    }

    protected void invalidateChildInfo() {
    }

    @Override
    public Node getParentNode() {
        if (this._parentNode == DummyNode.INSTANCE) {
            this._parentNode = this.getViewDocument().calculateParentNode(this);
        }
        return this._parentNode;
    }

    protected void setPreviousSibling(Node previousSibling) {
        this._previousSibling = previousSibling;
    }

    protected void setNextSibling(Node nextSibling) {
        this._nextSibling = nextSibling;
    }

    @Override
    public Node getPreviousSibling() {
        if (this._previousSibling == DummyNode.INSTANCE) {
            this._previousSibling = this.getViewDocument().calculatePreviousSibling(this);
        }
        return this._previousSibling;
    }

    @Override
    public Node getNextSibling() {
        if (this._nextSibling == DummyNode.INSTANCE) {
            this._nextSibling = this.getViewDocument().calculateNextSibling(this);
        }
        return this._nextSibling;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public Document getOwnerDocument() {
        return this.getViewDocument();
    }

    @Override
    public boolean hasChildNodes() {
        return false;
    }

    @Override
    public Node cloneNode(boolean deep) {
        return this.getProxiedNode().cloneNode(deep);
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    @Override
    public void addEventListener(String type, EventListener listener, boolean useCapture) {
        ((EventTarget)((Object)this.getProxiedNode())).addEventListener(type, this, useCapture);
    }

    @Override
    public void removeEventListener(String type, EventListener listener, boolean useCapture) {
        ((EventTarget)((Object)this.getProxiedNode())).removeEventListener(type, this, useCapture);
    }

    @Override
    public boolean dispatchEvent(Event evt) throws EventException {
        return true;
    }

    @Override
    public void handleEvent(Event evt) {
    }
}

