/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.view.proxy;

import java.util.HashMap;
import oracle.bali.xml.dom.util.DummyNode;
import oracle.bali.xml.dom.view.proxy.ContainerViewNode;
import oracle.bali.xml.dom.view.proxy.ViewAttr;
import oracle.bali.xml.dom.view.proxy.ViewCDATASection;
import oracle.bali.xml.dom.view.proxy.ViewComment;
import oracle.bali.xml.dom.view.proxy.ViewElement;
import oracle.bali.xml.dom.view.proxy.ViewEntity;
import oracle.bali.xml.dom.view.proxy.ViewEntityReference;
import oracle.bali.xml.dom.view.proxy.ViewEvent;
import oracle.bali.xml.dom.view.proxy.ViewNode;
import oracle.bali.xml.dom.view.proxy.ViewNotation;
import oracle.bali.xml.dom.view.proxy.ViewProcessingInstruction;
import oracle.bali.xml.dom.view.proxy.ViewText;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

public class ViewDocument
extends ContainerViewNode
implements Document,
DocumentEvent {
    private Document _baseDocument;
    private TreeWalker _filter;
    private static final String _ERR_MESSAGE = "Not implemented yet";
    private DocumentChangeListener _changeListener;
    private HashMap _modelToViewMap = new HashMap();

    public ViewDocument(Document baseDocument, TreeWalker filter) {
        super(baseDocument);
        if (baseDocument == null) {
            throw new IllegalArgumentException();
        }
        this._baseDocument = baseDocument;
        this.setViewDocument(this);
        this._filter = filter;
        EventTarget docEventTarget = (EventTarget)((Object)baseDocument);
        this._changeListener = new DocumentChangeListener();
        docEventTarget.addEventListener("DOMNodeInserted", this._changeListener, false);
        docEventTarget.addEventListener("DOMNodeRemoved", this._changeListener, false);
        docEventTarget.addEventListener("DOMAttrModified", this._changeListener, false);
    }

    @Override
    public String getNodeName() {
        return "#document";
    }

    @Override
    public String getNodeValue() throws DOMException {
        return null;
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        if (nodeValue != null) {
            throw new DOMException(7, "Documents can not have node values");
        }
    }

    @Override
    public short getNodeType() {
        return 9;
    }

    public void invalidateModelSubtree(Node modelNode) {
        Node viewNode;
        do {
            if ((viewNode = this.modelNodeToViewNode(modelNode)) != DummyNode.INSTANCE) continue;
            modelNode = viewNode.getParentNode();
        } while (modelNode != null);
        if (viewNode != null) {
            this._modelToViewMap.clear();
            ((ViewNode)viewNode).invalidateChildInfo();
            MutationEvent event = (MutationEvent)this.createEvent("MutationEvents");
            event.initMutationEvent("DOMSubtreeModified", true, false, null, null, null, null, (short)0);
            ((EventTarget)((Object)viewNode)).dispatchEvent(event);
        }
    }

    protected Node calculateParentNode(ViewNode proxyingNode) {
        Node modelParentNode;
        Node currentNode = proxyingNode.getProxiedNode();
        if (this._filter != null) {
            if (currentNode == this._filter.getRoot()) {
                return this;
            }
            Node oldNode = this._filter.getCurrentNode();
            this._filter.setCurrentNode(currentNode);
            modelParentNode = this._filter.parentNode();
            this._filter.setCurrentNode(oldNode);
        } else {
            modelParentNode = currentNode.getParentNode();
        }
        if (modelParentNode != null) {
            return this.modelNodeToViewNode(modelParentNode);
        }
        return null;
    }

    protected Node calculateNextSibling(ViewNode proxyingNode) {
        Node currentNode = proxyingNode.getProxiedNode();
        if (this._filter != null) {
            Node oldNode = this._filter.getCurrentNode();
            this._filter.setCurrentNode(currentNode);
            currentNode = this._filter.nextSibling();
            this._filter.setCurrentNode(oldNode);
        } else {
            currentNode = currentNode.getNextSibling();
        }
        ViewNode nextSibling = this.getNodeProxy(proxyingNode.getViewDocument(), proxyingNode.getParentNode(), currentNode);
        if (nextSibling != null) {
            nextSibling.setPreviousSibling(proxyingNode);
        }
        return nextSibling;
    }

    protected Node calculatePreviousSibling(ViewNode proxyingNode) {
        Node currentNode = proxyingNode.getProxiedNode();
        if (this._filter != null) {
            Node oldNode = this._filter.getCurrentNode();
            this._filter.setCurrentNode(currentNode);
            currentNode = this._filter.previousSibling();
            this._filter.setCurrentNode(oldNode);
        } else {
            currentNode = currentNode.getPreviousSibling();
        }
        ViewNode previousSibling = this.getNodeProxy(proxyingNode.getViewDocument(), proxyingNode.getParentNode(), currentNode);
        if (previousSibling != null) {
            previousSibling.setNextSibling(proxyingNode);
        }
        return previousSibling;
    }

    protected Node calculateFirstChild(ViewNode proxyingNode) {
        Node currentNode = proxyingNode.getProxiedNode();
        if (this._filter != null) {
            Node oldNode = this._filter.getCurrentNode();
            this._filter.setCurrentNode(currentNode);
            currentNode = this._filter.firstChild();
            this._filter.setCurrentNode(oldNode);
        } else {
            currentNode = currentNode.getFirstChild();
        }
        ViewNode firstChild = this.getNodeProxy(proxyingNode.getViewDocument(), proxyingNode, currentNode);
        if (firstChild != null) {
            firstChild.setPreviousSibling(null);
        }
        return firstChild;
    }

    protected Node calculateLastChild(ViewNode proxyingNode) {
        Node currentNode = proxyingNode.getProxiedNode();
        if (this._filter != null) {
            Node oldNode = this._filter.getCurrentNode();
            this._filter.setCurrentNode(currentNode);
            currentNode = this._filter.lastChild();
            this._filter.setCurrentNode(oldNode);
        } else {
            currentNode = currentNode.getLastChild();
        }
        ViewNode lastChild = this.getNodeProxy(proxyingNode.getViewDocument(), proxyingNode, currentNode);
        if (lastChild != null) {
            lastChild.setNextSibling(null);
        }
        return lastChild;
    }

    protected ViewNode getNodeProxy(ViewDocument document, Node parentNode, Node proxiedNode) {
        if (proxiedNode == null) {
            return null;
        }
        ViewNode viewNode = (ViewNode)this._modelToViewMap.get(proxiedNode);
        if (viewNode == null) {
            switch (proxiedNode.getNodeType()) {
                case 2: {
                    viewNode = new ViewAttr(proxiedNode);
                    break;
                }
                case 4: {
                    viewNode = new ViewCDATASection(proxiedNode);
                    break;
                }
                case 8: {
                    viewNode = new ViewComment(proxiedNode);
                    break;
                }
                case 11: {
                    break;
                }
                case 9: {
                    break;
                }
                case 10: {
                    break;
                }
                case 1: {
                    viewNode = new ViewElement(proxiedNode);
                    break;
                }
                case 6: {
                    viewNode = new ViewEntity(proxiedNode);
                    break;
                }
                case 5: {
                    viewNode = new ViewEntityReference(proxiedNode);
                    break;
                }
                case 12: {
                    viewNode = new ViewNotation(proxiedNode);
                    break;
                }
                case 7: {
                    viewNode = new ViewProcessingInstruction(proxiedNode);
                    break;
                }
                case 3: {
                    viewNode = new ViewText(proxiedNode);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown node type:" + proxiedNode.getNodeType());
                }
            }
            viewNode.setParentNode(parentNode);
            viewNode.setViewDocument(document);
            this._modelToViewMap.put(proxiedNode, viewNode);
        }
        return viewNode;
    }

    @Override
    public Node getParentNode() {
        return null;
    }

    @Override
    protected Node getProxiedNode() {
        return this.getProxiedDocument();
    }

    protected Document getProxiedDocument() {
        return this._baseDocument;
    }

    @Override
    public DocumentType getDoctype() {
        return this.getProxiedDocument().getDoctype();
    }

    @Override
    public DOMImplementation getImplementation() {
        return this.getProxiedDocument().getImplementation();
    }

    @Override
    public Element getDocumentElement() {
        return (Element)this.getFirstChild();
    }

    @Override
    public Element createElement(String tagName) throws DOMException {
        throw new DOMException(15, _ERR_MESSAGE);
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        throw new DOMException(15, _ERR_MESSAGE);
    }

    @Override
    public Text createTextNode(String data) {
        throw new DOMException(15, _ERR_MESSAGE);
    }

    @Override
    public Event createEvent(String eventType) throws DOMException {
        return null;
    }

    @Override
    public Comment createComment(String data) {
        throw new DOMException(15, _ERR_MESSAGE);
    }

    @Override
    public CDATASection createCDATASection(String data) throws DOMException {
        throw new DOMException(15, _ERR_MESSAGE);
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        throw new DOMException(15, _ERR_MESSAGE);
    }

    @Override
    public Attr createAttribute(String name) throws DOMException {
        throw new DOMException(15, _ERR_MESSAGE);
    }

    @Override
    public EntityReference createEntityReference(String name) throws DOMException {
        throw new DOMException(15, _ERR_MESSAGE);
    }

    @Override
    public NodeList getElementsByTagName(String tagname) {
        throw new DOMException(15, _ERR_MESSAGE);
    }

    @Override
    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        throw new DOMException(15, _ERR_MESSAGE);
    }

    @Override
    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        throw new DOMException(15, _ERR_MESSAGE);
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        throw new DOMException(15, _ERR_MESSAGE);
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        throw new DOMException(15, _ERR_MESSAGE);
    }

    @Override
    public Element getElementById(String elementId) {
        throw new DOMException(15, _ERR_MESSAGE);
    }

    private boolean _isModelNodeInView(Node modelNode) {
        int typeMask;
        if (this._filter == null) {
            return true;
        }
        Node viewNode = (Node)this._modelToViewMap.get(modelNode);
        if (viewNode == DummyNode.INSTANCE) {
            return false;
        }
        if (viewNode != null) {
            return true;
        }
        short nodeType = modelNode.getNodeType();
        int shownNodeTypes = this._filter.getWhatToShow();
        if ((shownNodeTypes & (typeMask = 1 << nodeType - 1)) == 0) {
            return false;
        }
        NodeFilter walkerFilter = this._filter.getFilter();
        if (walkerFilter != null && walkerFilter.acceptNode(modelNode) != 1) {
            return false;
        }
        if (modelNode == this._filter.getRoot()) {
            return true;
        }
        Node oldNode = this._filter.getCurrentNode();
        this._filter.setCurrentNode(modelNode);
        Node parentNode = this._filter.parentNode();
        this._filter.setCurrentNode(oldNode);
        if (parentNode == null) {
            return false;
        }
        return this._isModelNodeInView(parentNode);
    }

    public Node modelNodeToViewNode(Node modelNode) throws DOMException {
        Document nodeDocument = modelNode.getOwnerDocument();
        if (nodeDocument != this._baseDocument) {
            throw new DOMException(4, "Not model document:" + nodeDocument);
        }
        Node viewNode = (Node)this._modelToViewMap.get(modelNode);
        if (viewNode == null) {
            if (this._isModelNodeInView(modelNode)) {
                viewNode = this.getNodeProxy(this, (Node)DummyNode.INSTANCE, modelNode);
            } else {
                viewNode = DummyNode.INSTANCE;
                this._modelToViewMap.put(modelNode, viewNode);
            }
        }
        if (viewNode != DummyNode.INSTANCE) {
            return viewNode;
        }
        return null;
    }

    public Node viewNodeToModelNode(Node viewNode) {
        Document nodeDocument = viewNode.getOwnerDocument();
        if (nodeDocument != this) {
            throw new DOMException(4, "Not view document:" + nodeDocument);
        }
        return ((ViewNode)viewNode).getProxiedNode();
    }

    protected boolean dispatchEvent(Node viewNode, Event evt) {
        ViewEvent event = (ViewEvent)evt;
        return event.__doDefault();
    }

    @Override
    public Node adoptNode(Node source) throws DOMException {
        this.__nyi();
        return null;
    }

    @Override
    public String getDocumentURI() {
        this.__nyi();
        return null;
    }

    @Override
    public DOMConfiguration getDomConfig() {
        this.__nyi();
        return null;
    }

    @Override
    public String getInputEncoding() {
        this.__nyi();
        return null;
    }

    @Override
    public boolean getStrictErrorChecking() {
        this.__nyi();
        return false;
    }

    @Override
    public String getXmlEncoding() {
        this.__nyi();
        return null;
    }

    @Override
    public boolean getXmlStandalone() {
        this.__nyi();
        return false;
    }

    @Override
    public String getXmlVersion() {
        this.__nyi();
        return null;
    }

    @Override
    public void normalizeDocument() {
        this.__nyi();
    }

    @Override
    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        this.__nyi();
        return null;
    }

    @Override
    public void setDocumentURI(String documentURI) {
        this.__nyi();
    }

    @Override
    public void setStrictErrorChecking(boolean strictErrorChecking) {
        this.__nyi();
    }

    @Override
    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        this.__nyi();
    }

    @Override
    public void setXmlVersion(String xmlVersion) throws DOMException {
        this.__nyi();
    }

    private class DocumentChangeListener
    implements EventListener {
        private DocumentChangeListener() {
        }

        @Override
        public void handleEvent(Event event) {
            String eventType = event.getType();
            if ("DOMNodeRemoved".equals(eventType)) {
                MutationEvent mutationEvent = (MutationEvent)event;
            } else if ("DOMNodeInserted".equals(eventType) || "DOMAttrModified".equals(eventType)) {
                // empty if block
            }
        }
    }
}

