/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.impl;

import oracle.bali.xml.dom.changes.AttrAddedChange;
import oracle.bali.xml.dom.changes.AttrRemovedChange;
import oracle.bali.xml.dom.changes.AttrValueChange;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.DomChangeHandler;
import oracle.bali.xml.dom.changes.NodeInsertedChange;
import oracle.bali.xml.dom.changes.NodeRemovedChange;
import oracle.bali.xml.dom.changes.NodeValueChange;
import oracle.bali.xml.dom.impl.DomModelImpl;
import oracle.bali.xml.dom.ref.NodeRef;
import oracle.bali.xml.dom.util.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class UndoHandler
implements DomChangeHandler {
    private final DomModelImpl _model;

    UndoHandler(DomModelImpl model) {
        this._model = model;
    }

    @Override
    public final void handleAttrAddedChange(AttrAddedChange change) {
        this.preHook(change);
        DomUtils.removeAttr((Element)change.getOwnerElement(this.getDocument()), (Attr)change.getAddedAttributeClone());
        this.postHook(change);
    }

    @Override
    public final void handleNodeInsertedChange(NodeInsertedChange change) {
        this.preHook(change);
        DomUtils.removeChild((Document)this.getDocument(), (NodeRef)change.getNodeRef());
        this.postHook(change);
    }

    @Override
    public final void handleAttrValueChange(AttrValueChange change) {
        this.preHook(change);
        Attr attr = change.getChangedAttr(this.getDocument());
        attr.setValue(change.getPrevValue());
        this.postHook(change);
    }

    @Override
    public final void handleNodeValueChange(NodeValueChange change) {
        this.preHook(change);
        Node node = change.getNodeRef().getCorrespondingNode(this.getDocument());
        node.setNodeValue(change.getPrevValue());
        this.postHook(change);
    }

    @Override
    public void handleAttrRemovedChange(AttrRemovedChange change) {
        this.preHook(change);
        DomUtils.addAttr((Element)change.getOwnerElement(this.getDocument()), (Attr)change.getRemovedAttributeClone());
        this.postHook(change);
    }

    @Override
    public void handleNodeRemovedChange(NodeRemovedChange change) {
        this.preHook(change);
        DomUtils.addChild((Document)this.getDocument(), (NodeRef)change.getNodeRef(), (Node)change.getRemovedNodeClone());
        this.postHook(change);
    }

    protected final DomModelImpl getModel() {
        return this._model;
    }

    protected final Document getDocument() {
        return this._model.getDocument();
    }

    protected void preHook(DomChange change) {
        change.deliverRelatedChanges(this._model, 0);
    }

    protected void postHook(DomChange change) {
        change.deliverRelatedChanges(this._model, 1);
    }
}

