/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.impl;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.bali.xml.dom.impl.DomModelImpl;
import oracle.bali.xml.dom.util.DomUtils;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

class RemovedSubtreeListener
implements EventListener {
    private final Logger _logger;
    private Node _removedNode;
    private final Exception _removalException;

    public RemovedSubtreeListener(Node removedNode, Logger logger, Exception removalException) {
        this._logger = logger;
        this._removalException = removalException;
        this._removedNode = removedNode;
        DomModelImpl.__addDocListeners((EventTarget)((Object)this._removedNode), this);
    }

    public void dispose() {
        if (this._removedNode != null) {
            DomModelImpl.__removeDocListeners((EventTarget)((Object)this._removedNode), this);
            this._removedNode = null;
        }
    }

    public boolean isRemovedNodeInHierarchyNow() {
        if (this._removedNode == null) {
            return false;
        }
        return DomUtils.isInDocumentHierarchy((Node)this._removedNode);
    }

    @Override
    public void handleEvent(Event evt) {
        if ((!"DOMNodeInserted".equals(evt.getType()) || evt.getTarget() != this._removedNode) && this._logger.isLoggable(Level.WARNING)) {
            LogRecord lr = new LogRecord(Level.WARNING, "Subtree was modified in transaction after it was removed! See bug 3822372. Removed subtree root={0} Event={1}");
            lr.setParameters(new Object[]{this._removedNode.getNodeName(), DomUtils.getEventDebugMsg((MutationEvent)((MutationEvent)evt))});
            lr.setThrown(new RuntimeException("stack trace"));
            this._logger.log(lr);
            this._logger.log(Level.WARNING, "Removal stack trace", this._removalException);
        }
    }
}

